/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The caching configuration for a resolver that has caching enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CachingConfig implements SdkPojo, Serializable, ToCopyableBuilder<CachingConfig.Builder, CachingConfig> {
    private static final SdkField<Long> TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CachingConfig::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<List<String>> CACHING_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CachingConfig::cachingKeys))
            .setter(setter(Builder::cachingKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachingKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TTL_FIELD, CACHING_KEYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long ttl;

    private final List<String> cachingKeys;

    private CachingConfig(BuilderImpl builder) {
        this.ttl = builder.ttl;
        this.cachingKeys = builder.cachingKeys;
    }

    /**
     * <p>
     * The TTL in seconds for a resolver that has caching enabled.
     * </p>
     * <p>
     * Valid values are between 1 and 3600 seconds.
     * </p>
     * 
     * @return The TTL in seconds for a resolver that has caching enabled.</p>
     *         <p>
     *         Valid values are between 1 and 3600 seconds.
     */
    public Long ttl() {
        return ttl;
    }

    /**
     * Returns true if the CachingKeys property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCachingKeys() {
        return cachingKeys != null && !(cachingKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The caching keys for a resolver that has caching enabled.
     * </p>
     * <p>
     * Valid values are entries from the <code>$context.identity</code> and <code>$context.arguments</code> maps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCachingKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The caching keys for a resolver that has caching enabled.</p>
     *         <p>
     *         Valid values are entries from the <code>$context.identity</code> and <code>$context.arguments</code>
     *         maps.
     */
    public List<String> cachingKeys() {
        return cachingKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(cachingKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachingConfig)) {
            return false;
        }
        CachingConfig other = (CachingConfig) obj;
        return Objects.equals(ttl(), other.ttl()) && Objects.equals(cachingKeys(), other.cachingKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CachingConfig").add("Ttl", ttl()).add("CachingKeys", cachingKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "cachingKeys":
            return Optional.ofNullable(clazz.cast(cachingKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CachingConfig, T> g) {
        return obj -> g.apply((CachingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CachingConfig> {
        /**
         * <p>
         * The TTL in seconds for a resolver that has caching enabled.
         * </p>
         * <p>
         * Valid values are between 1 and 3600 seconds.
         * </p>
         * 
         * @param ttl
         *        The TTL in seconds for a resolver that has caching enabled.</p>
         *        <p>
         *        Valid values are between 1 and 3600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * The caching keys for a resolver that has caching enabled.
         * </p>
         * <p>
         * Valid values are entries from the <code>$context.identity</code> and <code>$context.arguments</code> maps.
         * </p>
         * 
         * @param cachingKeys
         *        The caching keys for a resolver that has caching enabled.</p>
         *        <p>
         *        Valid values are entries from the <code>$context.identity</code> and <code>$context.arguments</code>
         *        maps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingKeys(Collection<String> cachingKeys);

        /**
         * <p>
         * The caching keys for a resolver that has caching enabled.
         * </p>
         * <p>
         * Valid values are entries from the <code>$context.identity</code> and <code>$context.arguments</code> maps.
         * </p>
         * 
         * @param cachingKeys
         *        The caching keys for a resolver that has caching enabled.</p>
         *        <p>
         *        Valid values are entries from the <code>$context.identity</code> and <code>$context.arguments</code>
         *        maps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingKeys(String... cachingKeys);
    }

    static final class BuilderImpl implements Builder {
        private Long ttl;

        private List<String> cachingKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CachingConfig model) {
            ttl(model.ttl);
            cachingKeys(model.cachingKeys);
        }

        public final Long getTtl() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public final Collection<String> getCachingKeys() {
            return cachingKeys;
        }

        @Override
        public final Builder cachingKeys(Collection<String> cachingKeys) {
            this.cachingKeys = CachingKeysCopier.copy(cachingKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cachingKeys(String... cachingKeys) {
            cachingKeys(Arrays.asList(cachingKeys));
            return this;
        }

        public final void setCachingKeys(Collection<String> cachingKeys) {
            this.cachingKeys = CachingKeysCopier.copy(cachingKeys);
        }

        @Override
        public CachingConfig build() {
            return new CachingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
