/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResolverRequest extends AppSyncRequest implements
        ToCopyableBuilder<CreateResolverRequest.Builder, CreateResolverRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("typeName").build()).build();

    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRequest::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRequest::dataSourceName)).setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()).build();

    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRequest::requestMappingTemplate)).setter(setter(Builder::requestMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build())
            .build();

    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRequest::responseMappingTemplate)).setter(setter(Builder::responseMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build())
            .build();

    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRequest::kindAsString)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<PipelineConfig> PIPELINE_CONFIG_FIELD = SdkField
            .<PipelineConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateResolverRequest::pipelineConfig))
            .setter(setter(Builder::pipelineConfig)).constructor(PipelineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineConfig").build()).build();

    private static final SdkField<SyncConfig> SYNC_CONFIG_FIELD = SdkField.<SyncConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateResolverRequest::syncConfig)).setter(setter(Builder::syncConfig))
            .constructor(SyncConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncConfig").build()).build();

    private static final SdkField<CachingConfig> CACHING_CONFIG_FIELD = SdkField
            .<CachingConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateResolverRequest::cachingConfig))
            .setter(setter(Builder::cachingConfig)).constructor(CachingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, TYPE_NAME_FIELD,
            FIELD_NAME_FIELD, DATA_SOURCE_NAME_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD, RESPONSE_MAPPING_TEMPLATE_FIELD,
            KIND_FIELD, PIPELINE_CONFIG_FIELD, SYNC_CONFIG_FIELD, CACHING_CONFIG_FIELD));

    private final String apiId;

    private final String typeName;

    private final String fieldName;

    private final String dataSourceName;

    private final String requestMappingTemplate;

    private final String responseMappingTemplate;

    private final String kind;

    private final PipelineConfig pipelineConfig;

    private final SyncConfig syncConfig;

    private final CachingConfig cachingConfig;

    private CreateResolverRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.typeName = builder.typeName;
        this.fieldName = builder.fieldName;
        this.dataSourceName = builder.dataSourceName;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
        this.kind = builder.kind;
        this.pipelineConfig = builder.pipelineConfig;
        this.syncConfig = builder.syncConfig;
        this.cachingConfig = builder.cachingConfig;
    }

    /**
     * <p>
     * The ID for the GraphQL API for which the resolver is being created.
     * </p>
     * 
     * @return The ID for the GraphQL API for which the resolver is being created.
     */
    public String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The name of the <code>Type</code>.
     * </p>
     * 
     * @return The name of the <code>Type</code>.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The name of the field to attach the resolver to.
     * </p>
     * 
     * @return The name of the field to attach the resolver to.
     */
    public String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The name of the data source for which the resolver is being created.
     * </p>
     * 
     * @return The name of the data source for which the resolver is being created.
     */
    public String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The mapping template to be used for requests.
     * </p>
     * <p>
     * A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can
     * understand. Mapping templates are written in Apache Velocity Template Language (VTL).
     * </p>
     * 
     * @return The mapping template to be used for requests.</p>
     *         <p>
     *         A resolver uses a request mapping template to convert a GraphQL expression into a format that a data
     *         source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).
     */
    public String requestMappingTemplate() {
        return requestMappingTemplate;
    }

    /**
     * <p>
     * The mapping template to be used for responses from the data source.
     * </p>
     * 
     * @return The mapping template to be used for responses from the data source.
     */
    public String responseMappingTemplate() {
        return responseMappingTemplate;
    }

    /**
     * <p>
     * The resolver type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver enables you to
     * execute a GraphQL query against a single data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of
     * <code>Function</code> in a serial manner. You can use a pipeline resolver to execute a GraphQL query against
     * multiple data sources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link ResolverKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The resolver type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver enables
     *         you to execute a GraphQL query against a single data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of
     *         <code>Function</code> in a serial manner. You can use a pipeline resolver to execute a GraphQL query
     *         against multiple data sources.
     *         </p>
     *         </li>
     * @see ResolverKind
     */
    public ResolverKind kind() {
        return ResolverKind.fromValue(kind);
    }

    /**
     * <p>
     * The resolver type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver enables you to
     * execute a GraphQL query against a single data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of
     * <code>Function</code> in a serial manner. You can use a pipeline resolver to execute a GraphQL query against
     * multiple data sources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link ResolverKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The resolver type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver enables
     *         you to execute a GraphQL query against a single data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of
     *         <code>Function</code> in a serial manner. You can use a pipeline resolver to execute a GraphQL query
     *         against multiple data sources.
     *         </p>
     *         </li>
     * @see ResolverKind
     */
    public String kindAsString() {
        return kind;
    }

    /**
     * <p>
     * The <code>PipelineConfig</code>.
     * </p>
     * 
     * @return The <code>PipelineConfig</code>.
     */
    public PipelineConfig pipelineConfig() {
        return pipelineConfig;
    }

    /**
     * <p>
     * The <code>SyncConfig</code> for a resolver attached to a versioned datasource.
     * </p>
     * 
     * @return The <code>SyncConfig</code> for a resolver attached to a versioned datasource.
     */
    public SyncConfig syncConfig() {
        return syncConfig;
    }

    /**
     * <p>
     * The caching configuration for the resolver.
     * </p>
     * 
     * @return The caching configuration for the resolver.
     */
    public CachingConfig cachingConfig() {
        return cachingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(responseMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(syncConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cachingConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResolverRequest)) {
            return false;
        }
        CreateResolverRequest other = (CreateResolverRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(fieldName(), other.fieldName()) && Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(requestMappingTemplate(), other.requestMappingTemplate())
                && Objects.equals(responseMappingTemplate(), other.responseMappingTemplate())
                && Objects.equals(kindAsString(), other.kindAsString())
                && Objects.equals(pipelineConfig(), other.pipelineConfig()) && Objects.equals(syncConfig(), other.syncConfig())
                && Objects.equals(cachingConfig(), other.cachingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateResolverRequest").add("ApiId", apiId()).add("TypeName", typeName())
                .add("FieldName", fieldName()).add("DataSourceName", dataSourceName())
                .add("RequestMappingTemplate", requestMappingTemplate())
                .add("ResponseMappingTemplate", responseMappingTemplate()).add("Kind", kindAsString())
                .add("PipelineConfig", pipelineConfig()).add("SyncConfig", syncConfig()).add("CachingConfig", cachingConfig())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "fieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "dataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "requestMappingTemplate":
            return Optional.ofNullable(clazz.cast(requestMappingTemplate()));
        case "responseMappingTemplate":
            return Optional.ofNullable(clazz.cast(responseMappingTemplate()));
        case "kind":
            return Optional.ofNullable(clazz.cast(kindAsString()));
        case "pipelineConfig":
            return Optional.ofNullable(clazz.cast(pipelineConfig()));
        case "syncConfig":
            return Optional.ofNullable(clazz.cast(syncConfig()));
        case "cachingConfig":
            return Optional.ofNullable(clazz.cast(cachingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResolverRequest, T> g) {
        return obj -> g.apply((CreateResolverRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResolverRequest> {
        /**
         * <p>
         * The ID for the GraphQL API for which the resolver is being created.
         * </p>
         * 
         * @param apiId
         *        The ID for the GraphQL API for which the resolver is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The name of the <code>Type</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The name of the field to attach the resolver to.
         * </p>
         * 
         * @param fieldName
         *        The name of the field to attach the resolver to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The name of the data source for which the resolver is being created.
         * </p>
         * 
         * @param dataSourceName
         *        The name of the data source for which the resolver is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The mapping template to be used for requests.
         * </p>
         * <p>
         * A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source
         * can understand. Mapping templates are written in Apache Velocity Template Language (VTL).
         * </p>
         * 
         * @param requestMappingTemplate
         *        The mapping template to be used for requests.</p>
         *        <p>
         *        A resolver uses a request mapping template to convert a GraphQL expression into a format that a data
         *        source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMappingTemplate(String requestMappingTemplate);

        /**
         * <p>
         * The mapping template to be used for responses from the data source.
         * </p>
         * 
         * @param responseMappingTemplate
         *        The mapping template to be used for responses from the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseMappingTemplate(String responseMappingTemplate);

        /**
         * <p>
         * The resolver type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver enables you
         * to execute a GraphQL query against a single data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of
         * <code>Function</code> in a serial manner. You can use a pipeline resolver to execute a GraphQL query against
         * multiple data sources.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The resolver type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver
         *        enables you to execute a GraphQL query against a single data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of
         *        <code>Function</code> in a serial manner. You can use a pipeline resolver to execute a GraphQL query
         *        against multiple data sources.
         *        </p>
         *        </li>
         * @see ResolverKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverKind
         */
        Builder kind(String kind);

        /**
         * <p>
         * The resolver type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver enables you
         * to execute a GraphQL query against a single data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of
         * <code>Function</code> in a serial manner. You can use a pipeline resolver to execute a GraphQL query against
         * multiple data sources.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The resolver type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. A UNIT resolver
         *        enables you to execute a GraphQL query against a single data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE resolver enables you to execute a series of
         *        <code>Function</code> in a serial manner. You can use a pipeline resolver to execute a GraphQL query
         *        against multiple data sources.
         *        </p>
         *        </li>
         * @see ResolverKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverKind
         */
        Builder kind(ResolverKind kind);

        /**
         * <p>
         * The <code>PipelineConfig</code>.
         * </p>
         * 
         * @param pipelineConfig
         *        The <code>PipelineConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineConfig(PipelineConfig pipelineConfig);

        /**
         * <p>
         * The <code>PipelineConfig</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link PipelineConfig.Builder} avoiding the need to
         * create one manually via {@link PipelineConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineConfig(PipelineConfig)}.
         * 
         * @param pipelineConfig
         *        a consumer that will call methods on {@link PipelineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineConfig(PipelineConfig)
         */
        default Builder pipelineConfig(Consumer<PipelineConfig.Builder> pipelineConfig) {
            return pipelineConfig(PipelineConfig.builder().applyMutation(pipelineConfig).build());
        }

        /**
         * <p>
         * The <code>SyncConfig</code> for a resolver attached to a versioned datasource.
         * </p>
         * 
         * @param syncConfig
         *        The <code>SyncConfig</code> for a resolver attached to a versioned datasource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncConfig(SyncConfig syncConfig);

        /**
         * <p>
         * The <code>SyncConfig</code> for a resolver attached to a versioned datasource.
         * </p>
         * This is a convenience that creates an instance of the {@link SyncConfig.Builder} avoiding the need to create
         * one manually via {@link SyncConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SyncConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #syncConfig(SyncConfig)}.
         * 
         * @param syncConfig
         *        a consumer that will call methods on {@link SyncConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncConfig(SyncConfig)
         */
        default Builder syncConfig(Consumer<SyncConfig.Builder> syncConfig) {
            return syncConfig(SyncConfig.builder().applyMutation(syncConfig).build());
        }

        /**
         * <p>
         * The caching configuration for the resolver.
         * </p>
         * 
         * @param cachingConfig
         *        The caching configuration for the resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingConfig(CachingConfig cachingConfig);

        /**
         * <p>
         * The caching configuration for the resolver.
         * </p>
         * This is a convenience that creates an instance of the {@link CachingConfig.Builder} avoiding the need to
         * create one manually via {@link CachingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CachingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cachingConfig(CachingConfig)}.
         * 
         * @param cachingConfig
         *        a consumer that will call methods on {@link CachingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachingConfig(CachingConfig)
         */
        default Builder cachingConfig(Consumer<CachingConfig.Builder> cachingConfig) {
            return cachingConfig(CachingConfig.builder().applyMutation(cachingConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String typeName;

        private String fieldName;

        private String dataSourceName;

        private String requestMappingTemplate;

        private String responseMappingTemplate;

        private String kind;

        private PipelineConfig pipelineConfig;

        private SyncConfig syncConfig;

        private CachingConfig cachingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResolverRequest model) {
            super(model);
            apiId(model.apiId);
            typeName(model.typeName);
            fieldName(model.fieldName);
            dataSourceName(model.dataSourceName);
            requestMappingTemplate(model.requestMappingTemplate);
            responseMappingTemplate(model.responseMappingTemplate);
            kind(model.kind);
            pipelineConfig(model.pipelineConfig);
            syncConfig(model.syncConfig);
            cachingConfig(model.cachingConfig);
        }

        public final String getApiId() {
            return apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getFieldName() {
            return fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public final String getRequestMappingTemplate() {
            return requestMappingTemplate;
        }

        @Override
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        public final String getResponseMappingTemplate() {
            return responseMappingTemplate;
        }

        @Override
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        public final String getKindAsString() {
            return kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder kind(ResolverKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        public final PipelineConfig.Builder getPipelineConfig() {
            return pipelineConfig != null ? pipelineConfig.toBuilder() : null;
        }

        @Override
        public final Builder pipelineConfig(PipelineConfig pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        public final void setPipelineConfig(PipelineConfig.BuilderImpl pipelineConfig) {
            this.pipelineConfig = pipelineConfig != null ? pipelineConfig.build() : null;
        }

        public final SyncConfig.Builder getSyncConfig() {
            return syncConfig != null ? syncConfig.toBuilder() : null;
        }

        @Override
        public final Builder syncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public final void setSyncConfig(SyncConfig.BuilderImpl syncConfig) {
            this.syncConfig = syncConfig != null ? syncConfig.build() : null;
        }

        public final CachingConfig.Builder getCachingConfig() {
            return cachingConfig != null ? cachingConfig.toBuilder() : null;
        }

        @Override
        public final Builder cachingConfig(CachingConfig cachingConfig) {
            this.cachingConfig = cachingConfig;
            return this;
        }

        public final void setCachingConfig(CachingConfig.BuilderImpl cachingConfig) {
            this.cachingConfig = cachingConfig != null ? cachingConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResolverRequest build() {
            return new CreateResolverRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
