/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiCache implements SdkPojo, Serializable, ToCopyableBuilder<ApiCache.Builder, ApiCache> {
    private static final SdkField<Long> TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).getter(getter(ApiCache::ttl))
            .setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<String> API_CACHING_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApiCache::apiCachingBehaviorAsString)).setter(setter(Builder::apiCachingBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCachingBehavior").build())
            .build();

    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ApiCache::transitEncryptionEnabled)).setter(setter(Builder::transitEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitEncryptionEnabled").build())
            .build();

    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ApiCache::atRestEncryptionEnabled)).setter(setter(Builder::atRestEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atRestEncryptionEnabled").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApiCache::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApiCache::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TTL_FIELD,
            API_CACHING_BEHAVIOR_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, TYPE_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long ttl;

    private final String apiCachingBehavior;

    private final Boolean transitEncryptionEnabled;

    private final Boolean atRestEncryptionEnabled;

    private final String type;

    private final String status;

    private ApiCache(BuilderImpl builder) {
        this.ttl = builder.ttl;
        this.apiCachingBehavior = builder.apiCachingBehavior;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.type = builder.type;
        this.status = builder.status;
    }

    /**
     * <p>
     * TTL in seconds for cache entries.
     * </p>
     * <p>
     * Valid values are between 1 and 3600 seconds.
     * </p>
     * 
     * @return TTL in seconds for cache entries.</p>
     *         <p>
     *         Valid values are between 1 and 3600 seconds.
     */
    public Long ttl() {
        return ttl;
    }

    /**
     * <p>
     * Caching behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #apiCachingBehavior} will return {@link ApiCachingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #apiCachingBehaviorAsString}.
     * </p>
     * 
     * @return Caching behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
     *         </p>
     *         </li>
     * @see ApiCachingBehavior
     */
    public ApiCachingBehavior apiCachingBehavior() {
        return ApiCachingBehavior.fromValue(apiCachingBehavior);
    }

    /**
     * <p>
     * Caching behavior.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #apiCachingBehavior} will return {@link ApiCachingBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #apiCachingBehaviorAsString}.
     * </p>
     * 
     * @return Caching behavior.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
     *         </p>
     *         </li>
     * @see ApiCachingBehavior
     */
    public String apiCachingBehaviorAsString() {
        return apiCachingBehavior;
    }

    /**
     * <p>
     * Transit encryption flag when connecting to cache. This setting cannot be updated after creation.
     * </p>
     * 
     * @return Transit encryption flag when connecting to cache. This setting cannot be updated after creation.
     */
    public Boolean transitEncryptionEnabled() {
        return transitEncryptionEnabled;
    }

    /**
     * <p>
     * At rest encryption flag for cache. This setting cannot be updated after creation.
     * </p>
     * 
     * @return At rest encryption flag for cache. This setting cannot be updated after creation.
     */
    public Boolean atRestEncryptionEnabled() {
        return atRestEncryptionEnabled;
    }

    /**
     * <p>
     * The cache instance type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>T2_SMALL</b>: A t2.small instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>T2_MEDIUM</b>: A t2.medium instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_LARGE</b>: A r4.large instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_XLARGE</b>: A r4.xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApiCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The cache instance type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>T2_SMALL</b>: A t2.small instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>T2_MEDIUM</b>: A t2.medium instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_LARGE</b>: A r4.large instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_XLARGE</b>: A r4.xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
     *         </p>
     *         </li>
     * @see ApiCacheType
     */
    public ApiCacheType type() {
        return ApiCacheType.fromValue(type);
    }

    /**
     * <p>
     * The cache instance type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>T2_SMALL</b>: A t2.small instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>T2_MEDIUM</b>: A t2.medium instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_LARGE</b>: A r4.large instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_XLARGE</b>: A r4.xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ApiCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The cache instance type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>T2_SMALL</b>: A t2.small instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>T2_MEDIUM</b>: A t2.medium instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_LARGE</b>: A r4.large instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_XLARGE</b>: A r4.xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
     *         </p>
     *         </li>
     * @see ApiCacheType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The cache instance status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AVAILABLE</b>: The instance is available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATING</b>: The instance is currently creating.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETING</b>: The instance is currently deleting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MODIFYING</b>: The instance is currently modifying.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b>: The instance has failed creation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApiCacheStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The cache instance status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AVAILABLE</b>: The instance is available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREATING</b>: The instance is currently creating.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETING</b>: The instance is currently deleting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MODIFYING</b>: The instance is currently modifying.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b>: The instance has failed creation.
     *         </p>
     *         </li>
     * @see ApiCacheStatus
     */
    public ApiCacheStatus status() {
        return ApiCacheStatus.fromValue(status);
    }

    /**
     * <p>
     * The cache instance status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AVAILABLE</b>: The instance is available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CREATING</b>: The instance is currently creating.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DELETING</b>: The instance is currently deleting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MODIFYING</b>: The instance is currently modifying.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b>: The instance has failed creation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApiCacheStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The cache instance status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AVAILABLE</b>: The instance is available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CREATING</b>: The instance is currently creating.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DELETING</b>: The instance is currently deleting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MODIFYING</b>: The instance is currently modifying.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b>: The instance has failed creation.
     *         </p>
     *         </li>
     * @see ApiCacheStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(apiCachingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiCache)) {
            return false;
        }
        ApiCache other = (ApiCache) obj;
        return Objects.equals(ttl(), other.ttl())
                && Objects.equals(apiCachingBehaviorAsString(), other.apiCachingBehaviorAsString())
                && Objects.equals(transitEncryptionEnabled(), other.transitEncryptionEnabled())
                && Objects.equals(atRestEncryptionEnabled(), other.atRestEncryptionEnabled())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApiCache").add("Ttl", ttl()).add("ApiCachingBehavior", apiCachingBehaviorAsString())
                .add("TransitEncryptionEnabled", transitEncryptionEnabled())
                .add("AtRestEncryptionEnabled", atRestEncryptionEnabled()).add("Type", typeAsString())
                .add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "apiCachingBehavior":
            return Optional.ofNullable(clazz.cast(apiCachingBehaviorAsString()));
        case "transitEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(transitEncryptionEnabled()));
        case "atRestEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(atRestEncryptionEnabled()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiCache, T> g) {
        return obj -> g.apply((ApiCache) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiCache> {
        /**
         * <p>
         * TTL in seconds for cache entries.
         * </p>
         * <p>
         * Valid values are between 1 and 3600 seconds.
         * </p>
         * 
         * @param ttl
         *        TTL in seconds for cache entries.</p>
         *        <p>
         *        Valid values are between 1 and 3600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * Caching behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiCachingBehavior
         *        Caching behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
         *        </p>
         *        </li>
         * @see ApiCachingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCachingBehavior
         */
        Builder apiCachingBehavior(String apiCachingBehavior);

        /**
         * <p>
         * Caching behavior.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiCachingBehavior
         *        Caching behavior.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PER_RESOLVER_CACHING</b>: Individual resovlers that you specify are cached.
         *        </p>
         *        </li>
         * @see ApiCachingBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCachingBehavior
         */
        Builder apiCachingBehavior(ApiCachingBehavior apiCachingBehavior);

        /**
         * <p>
         * Transit encryption flag when connecting to cache. This setting cannot be updated after creation.
         * </p>
         * 
         * @param transitEncryptionEnabled
         *        Transit encryption flag when connecting to cache. This setting cannot be updated after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled);

        /**
         * <p>
         * At rest encryption flag for cache. This setting cannot be updated after creation.
         * </p>
         * 
         * @param atRestEncryptionEnabled
         *        At rest encryption flag for cache. This setting cannot be updated after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled);

        /**
         * <p>
         * The cache instance type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>T2_SMALL</b>: A t2.small instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>T2_MEDIUM</b>: A t2.medium instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_LARGE</b>: A r4.large instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_XLARGE</b>: A r4.xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The cache instance type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>T2_SMALL</b>: A t2.small instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>T2_MEDIUM</b>: A t2.medium instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_LARGE</b>: A r4.large instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_XLARGE</b>: A r4.xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
         *        </p>
         *        </li>
         * @see ApiCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCacheType
         */
        Builder type(String type);

        /**
         * <p>
         * The cache instance type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>T2_SMALL</b>: A t2.small instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>T2_MEDIUM</b>: A t2.medium instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_LARGE</b>: A r4.large instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_XLARGE</b>: A r4.xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The cache instance type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>T2_SMALL</b>: A t2.small instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>T2_MEDIUM</b>: A t2.medium instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_LARGE</b>: A r4.large instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_XLARGE</b>: A r4.xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_2XLARGE</b>: A r4.2xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_4XLARGE</b>: A r4.4xlarge instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>R4_8XLARGE</b>: A r4.8xlarge instance type.
         *        </p>
         *        </li>
         * @see ApiCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCacheType
         */
        Builder type(ApiCacheType type);

        /**
         * <p>
         * The cache instance status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AVAILABLE</b>: The instance is available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREATING</b>: The instance is currently creating.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETING</b>: The instance is currently deleting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MODIFYING</b>: The instance is currently modifying.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b>: The instance has failed creation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The cache instance status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AVAILABLE</b>: The instance is available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREATING</b>: The instance is currently creating.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETING</b>: The instance is currently deleting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MODIFYING</b>: The instance is currently modifying.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b>: The instance has failed creation.
         *        </p>
         *        </li>
         * @see ApiCacheStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCacheStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The cache instance status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AVAILABLE</b>: The instance is available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CREATING</b>: The instance is currently creating.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DELETING</b>: The instance is currently deleting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MODIFYING</b>: The instance is currently modifying.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b>: The instance has failed creation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The cache instance status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AVAILABLE</b>: The instance is available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CREATING</b>: The instance is currently creating.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DELETING</b>: The instance is currently deleting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MODIFYING</b>: The instance is currently modifying.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b>: The instance has failed creation.
         *        </p>
         *        </li>
         * @see ApiCacheStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiCacheStatus
         */
        Builder status(ApiCacheStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Long ttl;

        private String apiCachingBehavior;

        private Boolean transitEncryptionEnabled;

        private Boolean atRestEncryptionEnabled;

        private String type;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiCache model) {
            ttl(model.ttl);
            apiCachingBehavior(model.apiCachingBehavior);
            transitEncryptionEnabled(model.transitEncryptionEnabled);
            atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            type(model.type);
            status(model.status);
        }

        public final Long getTtl() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public final String getApiCachingBehaviorAsString() {
            return apiCachingBehavior;
        }

        @Override
        public final Builder apiCachingBehavior(String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
            return this;
        }

        @Override
        public final Builder apiCachingBehavior(ApiCachingBehavior apiCachingBehavior) {
            this.apiCachingBehavior(apiCachingBehavior == null ? null : apiCachingBehavior.toString());
            return this;
        }

        public final void setApiCachingBehavior(String apiCachingBehavior) {
            this.apiCachingBehavior = apiCachingBehavior;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApiCacheType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApiCacheStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ApiCache build() {
            return new ApiCache(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
