/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appsync.model.DataSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DataSourceMarshaller {
    private static final MarshallingInfo<String> DATASOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSourceArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceRoleArn").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DYNAMODBCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamodbConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elasticsearchConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HTTPCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpConfig").isBinary(false).build();
    private static final DataSourceMarshaller INSTANCE = new DataSourceMarshaller();

    private DataSourceMarshaller() {
    }

    public static DataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DataSource dataSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dataSource, (String)"dataSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dataSource.dataSourceArn(), DATASOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)dataSource.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)dataSource.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)dataSource.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)dataSource.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)dataSource.dynamodbConfig(), DYNAMODBCONFIG_BINDING);
            protocolMarshaller.marshall((Object)dataSource.lambdaConfig(), LAMBDACONFIG_BINDING);
            protocolMarshaller.marshall((Object)dataSource.elasticsearchConfig(), ELASTICSEARCHCONFIG_BINDING);
            protocolMarshaller.marshall((Object)dataSource.httpConfig(), HTTPCONFIG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

