/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.services.appstream.model.FleetError;
import software.amazon.awssdk.services.appstream.model.FleetErrorsCopier;
import software.amazon.awssdk.services.appstream.model.FleetState;
import software.amazon.awssdk.services.appstream.model.FleetType;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Fleet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Fleet> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::arn)).setter(Fleet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::name)).setter(Fleet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::displayName)).setter(Fleet.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::description)).setter(Fleet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::imageName)).setter(Fleet.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::imageArn)).setter(Fleet.setter(Builder::imageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::instanceType)).setter(Fleet.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::fleetTypeAsString)).setter(Fleet.setter(Builder::fleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()}).build();
    private static final SdkField<ComputeCapacityStatus> COMPUTE_CAPACITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Fleet.getter(Fleet::computeCapacityStatus)).setter(Fleet.setter(Builder::computeCapacityStatus)).constructor(ComputeCapacityStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeCapacityStatus").build()}).build();
    private static final SdkField<Integer> MAX_USER_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Fleet.getter(Fleet::maxUserDurationInSeconds)).setter(Fleet.setter(Builder::maxUserDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUserDurationInSeconds").build()}).build();
    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Fleet.getter(Fleet::disconnectTimeoutInSeconds)).setter(Fleet.setter(Builder::disconnectTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimeoutInSeconds").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Fleet.getter(Fleet::stateAsString)).setter(Fleet.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Fleet.getter(Fleet::vpcConfig)).setter(Fleet.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Fleet.getter(Fleet::createdTime)).setter(Fleet.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<List<FleetError>> FLEET_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Fleet.getter(Fleet::fleetErrors)).setter(Fleet.setter(Builder::fleetErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Fleet.getter(Fleet::enableDefaultInternetAccess)).setter(Fleet.setter(Builder::enableDefaultInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess").build()}).build();
    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Fleet.getter(Fleet::domainJoinInfo)).setter(Fleet.setter(Builder::domainJoinInfo)).constructor(DomainJoinInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()}).build();
    private static final SdkField<Integer> IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Fleet.getter(Fleet::idleDisconnectTimeoutInSeconds)).setter(Fleet.setter(Builder::idleDisconnectTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleDisconnectTimeoutInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, IMAGE_NAME_FIELD, IMAGE_ARN_FIELD, INSTANCE_TYPE_FIELD, FLEET_TYPE_FIELD, COMPUTE_CAPACITY_STATUS_FIELD, MAX_USER_DURATION_IN_SECONDS_FIELD, DISCONNECT_TIMEOUT_IN_SECONDS_FIELD, STATE_FIELD, VPC_CONFIG_FIELD, CREATED_TIME_FIELD, FLEET_ERRORS_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, DOMAIN_JOIN_INFO_FIELD, IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String displayName;
    private final String description;
    private final String imageName;
    private final String imageArn;
    private final String instanceType;
    private final String fleetType;
    private final ComputeCapacityStatus computeCapacityStatus;
    private final Integer maxUserDurationInSeconds;
    private final Integer disconnectTimeoutInSeconds;
    private final String state;
    private final VpcConfig vpcConfig;
    private final Instant createdTime;
    private final List<FleetError> fleetErrors;
    private final Boolean enableDefaultInternetAccess;
    private final DomainJoinInfo domainJoinInfo;
    private final Integer idleDisconnectTimeoutInSeconds;

    private Fleet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.instanceType = builder.instanceType;
        this.fleetType = builder.fleetType;
        this.computeCapacityStatus = builder.computeCapacityStatus;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.state = builder.state;
        this.vpcConfig = builder.vpcConfig;
        this.createdTime = builder.createdTime;
        this.fleetErrors = builder.fleetErrors;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.idleDisconnectTimeoutInSeconds = builder.idleDisconnectTimeoutInSeconds;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String imageName() {
        return this.imageName;
    }

    public String imageArn() {
        return this.imageArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public FleetType fleetType() {
        return FleetType.fromValue(this.fleetType);
    }

    public String fleetTypeAsString() {
        return this.fleetType;
    }

    public ComputeCapacityStatus computeCapacityStatus() {
        return this.computeCapacityStatus;
    }

    public Integer maxUserDurationInSeconds() {
        return this.maxUserDurationInSeconds;
    }

    public Integer disconnectTimeoutInSeconds() {
        return this.disconnectTimeoutInSeconds;
    }

    public FleetState state() {
        return FleetState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public List<FleetError> fleetErrors() {
        return this.fleetErrors;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public DomainJoinInfo domainJoinInfo() {
        return this.domainJoinInfo;
    }

    public Integer idleDisconnectTimeoutInSeconds() {
        return this.idleDisconnectTimeoutInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeCapacityStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUserDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleDisconnectTimeoutInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.fleetTypeAsString(), other.fleetTypeAsString()) && Objects.equals(this.computeCapacityStatus(), other.computeCapacityStatus()) && Objects.equals(this.maxUserDurationInSeconds(), other.maxUserDurationInSeconds()) && Objects.equals(this.disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.fleetErrors(), other.fleetErrors()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.domainJoinInfo(), other.domainJoinInfo()) && Objects.equals(this.idleDisconnectTimeoutInSeconds(), other.idleDisconnectTimeoutInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"Fleet").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("ImageName", (Object)this.imageName()).add("ImageArn", (Object)this.imageArn()).add("InstanceType", (Object)this.instanceType()).add("FleetType", (Object)this.fleetTypeAsString()).add("ComputeCapacityStatus", (Object)this.computeCapacityStatus()).add("MaxUserDurationInSeconds", (Object)this.maxUserDurationInSeconds()).add("DisconnectTimeoutInSeconds", (Object)this.disconnectTimeoutInSeconds()).add("State", (Object)this.stateAsString()).add("VpcConfig", (Object)this.vpcConfig()).add("CreatedTime", (Object)this.createdTime()).add("FleetErrors", this.fleetErrors()).add("EnableDefaultInternetAccess", (Object)this.enableDefaultInternetAccess()).add("DomainJoinInfo", (Object)this.domainJoinInfo()).add("IdleDisconnectTimeoutInSeconds", (Object)this.idleDisconnectTimeoutInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "FleetType": {
                return Optional.ofNullable(clazz.cast(this.fleetTypeAsString()));
            }
            case "ComputeCapacityStatus": {
                return Optional.ofNullable(clazz.cast(this.computeCapacityStatus()));
            }
            case "MaxUserDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxUserDurationInSeconds()));
            }
            case "DisconnectTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.disconnectTimeoutInSeconds()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "FleetErrors": {
                return Optional.ofNullable(clazz.cast(this.fleetErrors()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "DomainJoinInfo": {
                return Optional.ofNullable(clazz.cast(this.domainJoinInfo()));
            }
            case "IdleDisconnectTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleDisconnectTimeoutInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fleet, T> g) {
        return obj -> g.apply((Fleet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String displayName;
        private String description;
        private String imageName;
        private String imageArn;
        private String instanceType;
        private String fleetType;
        private ComputeCapacityStatus computeCapacityStatus;
        private Integer maxUserDurationInSeconds;
        private Integer disconnectTimeoutInSeconds;
        private String state;
        private VpcConfig vpcConfig;
        private Instant createdTime;
        private List<FleetError> fleetErrors = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableDefaultInternetAccess;
        private DomainJoinInfo domainJoinInfo;
        private Integer idleDisconnectTimeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            this.arn(model.arn);
            this.name(model.name);
            this.displayName(model.displayName);
            this.description(model.description);
            this.imageName(model.imageName);
            this.imageArn(model.imageArn);
            this.instanceType(model.instanceType);
            this.fleetType(model.fleetType);
            this.computeCapacityStatus(model.computeCapacityStatus);
            this.maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            this.disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            this.state(model.state);
            this.vpcConfig(model.vpcConfig);
            this.createdTime(model.createdTime);
            this.fleetErrors(model.fleetErrors);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.domainJoinInfo(model.domainJoinInfo);
            this.idleDisconnectTimeoutInSeconds(model.idleDisconnectTimeoutInSeconds);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getFleetTypeAsString() {
            return this.fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType.toString());
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final ComputeCapacityStatus.Builder getComputeCapacityStatus() {
            return this.computeCapacityStatus != null ? this.computeCapacityStatus.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus;
            return this;
        }

        public final void setComputeCapacityStatus(ComputeCapacityStatus.BuilderImpl computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus != null ? computeCapacityStatus.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return this.maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return this.disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FleetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<FleetError.Builder> getFleetErrors() {
            return this.fleetErrors != null ? (Collection)this.fleetErrors.stream().map(FleetError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetErrors(Collection<FleetError> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copy(fleetErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(FleetError ... fleetErrors) {
            this.fleetErrors(Arrays.asList(fleetErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(Consumer<FleetError.Builder> ... fleetErrors) {
            this.fleetErrors(Stream.of(fleetErrors).map(c -> (FleetError)((FleetError.Builder)FleetError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFleetErrors(Collection<FleetError.BuilderImpl> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copyFromBuilder(fleetErrors);
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return this.domainJoinInfo != null ? this.domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final Integer getIdleDisconnectTimeoutInSeconds() {
            return this.idleDisconnectTimeoutInSeconds;
        }

        @Override
        public final Builder idleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
            return this;
        }

        public final void setIdleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
        }

        public Fleet build() {
            return new Fleet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Fleet> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder imageName(String var1);

        public Builder imageArn(String var1);

        public Builder instanceType(String var1);

        public Builder fleetType(String var1);

        public Builder fleetType(FleetType var1);

        public Builder computeCapacityStatus(ComputeCapacityStatus var1);

        default public Builder computeCapacityStatus(Consumer<ComputeCapacityStatus.Builder> computeCapacityStatus) {
            return this.computeCapacityStatus((ComputeCapacityStatus)((ComputeCapacityStatus.Builder)ComputeCapacityStatus.builder().applyMutation(computeCapacityStatus)).build());
        }

        public Builder maxUserDurationInSeconds(Integer var1);

        public Builder disconnectTimeoutInSeconds(Integer var1);

        public Builder state(String var1);

        public Builder state(FleetState var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder fleetErrors(Collection<FleetError> var1);

        public Builder fleetErrors(FleetError ... var1);

        public Builder fleetErrors(Consumer<FleetError.Builder> ... var1);

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder domainJoinInfo(DomainJoinInfo var1);

        default public Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return this.domainJoinInfo((DomainJoinInfo)((DomainJoinInfo.Builder)DomainJoinInfo.builder().applyMutation(domainJoinInfo)).build());
        }

        public Builder idleDisconnectTimeoutInSeconds(Integer var1);
    }
}

