/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSoftwareDeploymentToImageBuilderRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, StartSoftwareDeploymentToImageBuilderRequest> {
    private static final SdkField<String> IMAGE_BUILDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBuilderName").getter(StartSoftwareDeploymentToImageBuilderRequest.getter(StartSoftwareDeploymentToImageBuilderRequest::imageBuilderName)).setter(StartSoftwareDeploymentToImageBuilderRequest.setter(Builder::imageBuilderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderName").build()}).build();
    private static final SdkField<Boolean> RETRY_FAILED_DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RetryFailedDeployments").getter(StartSoftwareDeploymentToImageBuilderRequest.getter(StartSoftwareDeploymentToImageBuilderRequest::retryFailedDeployments)).setter(StartSoftwareDeploymentToImageBuilderRequest.setter(Builder::retryFailedDeployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryFailedDeployments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_BUILDER_NAME_FIELD, RETRY_FAILED_DEPLOYMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSoftwareDeploymentToImageBuilderRequest.memberNameToFieldInitializer();
    private final String imageBuilderName;
    private final Boolean retryFailedDeployments;

    private StartSoftwareDeploymentToImageBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.imageBuilderName = builder.imageBuilderName;
        this.retryFailedDeployments = builder.retryFailedDeployments;
    }

    public final String imageBuilderName() {
        return this.imageBuilderName;
    }

    public final Boolean retryFailedDeployments() {
        return this.retryFailedDeployments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryFailedDeployments());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSoftwareDeploymentToImageBuilderRequest)) {
            return false;
        }
        StartSoftwareDeploymentToImageBuilderRequest other = (StartSoftwareDeploymentToImageBuilderRequest)((Object)obj);
        return Objects.equals(this.imageBuilderName(), other.imageBuilderName()) && Objects.equals(this.retryFailedDeployments(), other.retryFailedDeployments());
    }

    public final String toString() {
        return ToString.builder((String)"StartSoftwareDeploymentToImageBuilderRequest").add("ImageBuilderName", (Object)this.imageBuilderName()).add("RetryFailedDeployments", (Object)this.retryFailedDeployments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageBuilderName": {
                return Optional.ofNullable(clazz.cast(this.imageBuilderName()));
            }
            case "RetryFailedDeployments": {
                return Optional.ofNullable(clazz.cast(this.retryFailedDeployments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageBuilderName", IMAGE_BUILDER_NAME_FIELD);
        map.put("RetryFailedDeployments", RETRY_FAILED_DEPLOYMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSoftwareDeploymentToImageBuilderRequest, T> g) {
        return obj -> g.apply((StartSoftwareDeploymentToImageBuilderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String imageBuilderName;
        private Boolean retryFailedDeployments;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSoftwareDeploymentToImageBuilderRequest model) {
            super(model);
            this.imageBuilderName(model.imageBuilderName);
            this.retryFailedDeployments(model.retryFailedDeployments);
        }

        public final String getImageBuilderName() {
            return this.imageBuilderName;
        }

        public final void setImageBuilderName(String imageBuilderName) {
            this.imageBuilderName = imageBuilderName;
        }

        @Override
        public final Builder imageBuilderName(String imageBuilderName) {
            this.imageBuilderName = imageBuilderName;
            return this;
        }

        public final Boolean getRetryFailedDeployments() {
            return this.retryFailedDeployments;
        }

        public final void setRetryFailedDeployments(Boolean retryFailedDeployments) {
            this.retryFailedDeployments = retryFailedDeployments;
        }

        @Override
        public final Builder retryFailedDeployments(Boolean retryFailedDeployments) {
            this.retryFailedDeployments = retryFailedDeployments;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSoftwareDeploymentToImageBuilderRequest build() {
            return new StartSoftwareDeploymentToImageBuilderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSoftwareDeploymentToImageBuilderRequest> {
        public Builder imageBuilderName(String var1);

        public Builder retryFailedDeployments(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

