/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExportImageTaskRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateExportImageTaskRequest> {
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(CreateExportImageTaskRequest.getter(CreateExportImageTaskRequest::imageName)).setter(CreateExportImageTaskRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> AMI_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiName").getter(CreateExportImageTaskRequest.getter(CreateExportImageTaskRequest::amiName)).setter(CreateExportImageTaskRequest.setter(Builder::amiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiName").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CreateExportImageTaskRequest.getter(CreateExportImageTaskRequest::iamRoleArn)).setter(CreateExportImageTaskRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TagSpecifications").getter(CreateExportImageTaskRequest.getter(CreateExportImageTaskRequest::tagSpecifications)).setter(CreateExportImageTaskRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecifications").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> AMI_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiDescription").getter(CreateExportImageTaskRequest.getter(CreateExportImageTaskRequest::amiDescription)).setter(CreateExportImageTaskRequest.setter(Builder::amiDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_NAME_FIELD, AMI_NAME_FIELD, IAM_ROLE_ARN_FIELD, TAG_SPECIFICATIONS_FIELD, AMI_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExportImageTaskRequest.memberNameToFieldInitializer();
    private final String imageName;
    private final String amiName;
    private final String iamRoleArn;
    private final Map<String, String> tagSpecifications;
    private final String amiDescription;

    private CreateExportImageTaskRequest(BuilderImpl builder) {
        super(builder);
        this.imageName = builder.imageName;
        this.amiName = builder.amiName;
        this.iamRoleArn = builder.iamRoleArn;
        this.tagSpecifications = builder.tagSpecifications;
        this.amiDescription = builder.amiDescription;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final String amiName() {
        return this.amiName;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String amiDescription() {
        return this.amiDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.amiDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportImageTaskRequest)) {
            return false;
        }
        CreateExportImageTaskRequest other = (CreateExportImageTaskRequest)((Object)obj);
        return Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.amiName(), other.amiName()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.amiDescription(), other.amiDescription());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExportImageTaskRequest").add("ImageName", (Object)this.imageName()).add("AmiName", (Object)this.amiName()).add("IamRoleArn", (Object)this.iamRoleArn()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("AmiDescription", (Object)this.amiDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "AmiName": {
                return Optional.ofNullable(clazz.cast(this.amiName()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "AmiDescription": {
                return Optional.ofNullable(clazz.cast(this.amiDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageName", IMAGE_NAME_FIELD);
        map.put("AmiName", AMI_NAME_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("TagSpecifications", TAG_SPECIFICATIONS_FIELD);
        map.put("AmiDescription", AMI_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExportImageTaskRequest, T> g) {
        return obj -> g.apply((CreateExportImageTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String imageName;
        private String amiName;
        private String iamRoleArn;
        private Map<String, String> tagSpecifications = DefaultSdkAutoConstructMap.getInstance();
        private String amiDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportImageTaskRequest model) {
            super(model);
            this.imageName(model.imageName);
            this.amiName(model.amiName);
            this.iamRoleArn(model.iamRoleArn);
            this.tagSpecifications(model.tagSpecifications);
            this.amiDescription(model.amiDescription);
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getAmiName() {
            return this.amiName;
        }

        public final void setAmiName(String amiName) {
            this.amiName = amiName;
        }

        @Override
        public final Builder amiName(String amiName) {
            this.amiName = amiName;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Map<String, String> getTagSpecifications() {
            if (this.tagSpecifications instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tagSpecifications;
        }

        public final void setTagSpecifications(Map<String, String> tagSpecifications) {
            this.tagSpecifications = TagsCopier.copy(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Map<String, String> tagSpecifications) {
            this.tagSpecifications = TagsCopier.copy(tagSpecifications);
            return this;
        }

        public final String getAmiDescription() {
            return this.amiDescription;
        }

        public final void setAmiDescription(String amiDescription) {
            this.amiDescription = amiDescription;
        }

        @Override
        public final Builder amiDescription(String amiDescription) {
            this.amiDescription = amiDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportImageTaskRequest build() {
            return new CreateExportImageTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExportImageTaskRequest> {
        public Builder imageName(String var1);

        public Builder amiName(String var1);

        public Builder iamRoleArn(String var1);

        public Builder tagSpecifications(Map<String, String> var1);

        public Builder amiDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

