/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.UserStackAssociation;
import software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserStackAssociationError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserStackAssociationError> {
    private static final SdkField<UserStackAssociation> USER_STACK_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserStackAssociation").getter(UserStackAssociationError.getter(UserStackAssociationError::userStackAssociation)).setter(UserStackAssociationError.setter(Builder::userStackAssociation)).constructor(UserStackAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStackAssociation").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(UserStackAssociationError.getter(UserStackAssociationError::errorCodeAsString)).setter(UserStackAssociationError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(UserStackAssociationError.getter(UserStackAssociationError::errorMessage)).setter(UserStackAssociationError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_STACK_ASSOCIATION_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserStackAssociationError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final UserStackAssociation userStackAssociation;
    private final String errorCode;
    private final String errorMessage;

    private UserStackAssociationError(BuilderImpl builder) {
        this.userStackAssociation = builder.userStackAssociation;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final UserStackAssociation userStackAssociation() {
        return this.userStackAssociation;
    }

    public final UserStackAssociationErrorCode errorCode() {
        return UserStackAssociationErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userStackAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserStackAssociationError)) {
            return false;
        }
        UserStackAssociationError other = (UserStackAssociationError)obj;
        return Objects.equals(this.userStackAssociation(), other.userStackAssociation()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"UserStackAssociationError").add("UserStackAssociation", (Object)this.userStackAssociation()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserStackAssociation": {
                return Optional.ofNullable(clazz.cast(this.userStackAssociation()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserStackAssociation", USER_STACK_ASSOCIATION_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserStackAssociationError, T> g) {
        return obj -> g.apply((UserStackAssociationError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UserStackAssociation userStackAssociation;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UserStackAssociationError model) {
            this.userStackAssociation(model.userStackAssociation);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final UserStackAssociation.Builder getUserStackAssociation() {
            return this.userStackAssociation != null ? this.userStackAssociation.toBuilder() : null;
        }

        public final void setUserStackAssociation(UserStackAssociation.BuilderImpl userStackAssociation) {
            this.userStackAssociation = userStackAssociation != null ? userStackAssociation.build() : null;
        }

        @Override
        public final Builder userStackAssociation(UserStackAssociation userStackAssociation) {
            this.userStackAssociation = userStackAssociation;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(UserStackAssociationErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public UserStackAssociationError build() {
            return new UserStackAssociationError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserStackAssociationError> {
        public Builder userStackAssociation(UserStackAssociation var1);

        default public Builder userStackAssociation(Consumer<UserStackAssociation.Builder> userStackAssociation) {
            return this.userStackAssociation((UserStackAssociation)((UserStackAssociation.Builder)UserStackAssociation.builder().applyMutation(userStackAssociation)).build());
        }

        public Builder errorCode(String var1);

        public Builder errorCode(UserStackAssociationErrorCode var1);

        public Builder errorMessage(String var1);
    }
}

