/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.ApplicationFleetAssociation;
import software.amazon.awssdk.services.appstream.model.ApplicationFleetAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationFleetAssociationsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeApplicationFleetAssociationsResponse> {
    private static final SdkField<List<ApplicationFleetAssociation>> APPLICATION_FLEET_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationFleetAssociations").getter(DescribeApplicationFleetAssociationsResponse.getter(DescribeApplicationFleetAssociationsResponse::applicationFleetAssociations)).setter(DescribeApplicationFleetAssociationsResponse.setter(Builder::applicationFleetAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationFleetAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationFleetAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeApplicationFleetAssociationsResponse.getter(DescribeApplicationFleetAssociationsResponse::nextToken)).setter(DescribeApplicationFleetAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FLEET_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationFleetAssociations", APPLICATION_FLEET_ASSOCIATIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ApplicationFleetAssociation> applicationFleetAssociations;
    private final String nextToken;

    private DescribeApplicationFleetAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationFleetAssociations = builder.applicationFleetAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationFleetAssociations() {
        return this.applicationFleetAssociations != null && !(this.applicationFleetAssociations instanceof SdkAutoConstructList);
    }

    public final List<ApplicationFleetAssociation> applicationFleetAssociations() {
        return this.applicationFleetAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationFleetAssociations() ? this.applicationFleetAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationFleetAssociationsResponse)) {
            return false;
        }
        DescribeApplicationFleetAssociationsResponse other = (DescribeApplicationFleetAssociationsResponse)((Object)obj);
        return this.hasApplicationFleetAssociations() == other.hasApplicationFleetAssociations() && Objects.equals(this.applicationFleetAssociations(), other.applicationFleetAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationFleetAssociationsResponse").add("ApplicationFleetAssociations", this.hasApplicationFleetAssociations() ? this.applicationFleetAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationFleetAssociations": {
                return Optional.ofNullable(clazz.cast(this.applicationFleetAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationFleetAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationFleetAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<ApplicationFleetAssociation> applicationFleetAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationFleetAssociationsResponse model) {
            super(model);
            this.applicationFleetAssociations(model.applicationFleetAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationFleetAssociation.Builder> getApplicationFleetAssociations() {
            List<ApplicationFleetAssociation.Builder> result = ApplicationFleetAssociationListCopier.copyToBuilder(this.applicationFleetAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationFleetAssociations(Collection<ApplicationFleetAssociation.BuilderImpl> applicationFleetAssociations) {
            this.applicationFleetAssociations = ApplicationFleetAssociationListCopier.copyFromBuilder(applicationFleetAssociations);
        }

        @Override
        public final Builder applicationFleetAssociations(Collection<ApplicationFleetAssociation> applicationFleetAssociations) {
            this.applicationFleetAssociations = ApplicationFleetAssociationListCopier.copy(applicationFleetAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationFleetAssociations(ApplicationFleetAssociation ... applicationFleetAssociations) {
            this.applicationFleetAssociations(Arrays.asList(applicationFleetAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationFleetAssociations(Consumer<ApplicationFleetAssociation.Builder> ... applicationFleetAssociations) {
            this.applicationFleetAssociations(Stream.of(applicationFleetAssociations).map(c -> (ApplicationFleetAssociation)((ApplicationFleetAssociation.Builder)ApplicationFleetAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeApplicationFleetAssociationsResponse build() {
            return new DescribeApplicationFleetAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationFleetAssociationsResponse> {
        public Builder applicationFleetAssociations(Collection<ApplicationFleetAssociation> var1);

        public Builder applicationFleetAssociations(ApplicationFleetAssociation ... var1);

        public Builder applicationFleetAssociations(Consumer<ApplicationFleetAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

