/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PlatformType {
    WINDOWS("WINDOWS"),
    WINDOWS_SERVER_2016("WINDOWS_SERVER_2016"),
    WINDOWS_SERVER_2019("WINDOWS_SERVER_2019"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PlatformType> VALUE_MAP;
    private final String value;

    private PlatformType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PlatformType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PlatformType> knownValues() {
        EnumSet<PlatformType> knownValues = EnumSet.allOf(PlatformType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PlatformType.class, PlatformType::toString);
    }
}

