/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FleetType {
    ALWAYS_ON("ALWAYS_ON"),
    ON_DEMAND("ON_DEMAND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FleetType> VALUE_MAP;
    private final String value;

    private FleetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FleetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FleetType> knownValues() {
        EnumSet<FleetType> knownValues = EnumSet.allOf(FleetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FleetType.class, FleetType::toString);
    }
}

