/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Action {
    CLIPBOARD_COPY_FROM_LOCAL_DEVICE("CLIPBOARD_COPY_FROM_LOCAL_DEVICE"),
    CLIPBOARD_COPY_TO_LOCAL_DEVICE("CLIPBOARD_COPY_TO_LOCAL_DEVICE"),
    FILE_UPLOAD("FILE_UPLOAD"),
    FILE_DOWNLOAD("FILE_DOWNLOAD"),
    PRINTING_TO_LOCAL_DEVICE("PRINTING_TO_LOCAL_DEVICE"),
    DOMAIN_PASSWORD_SIGNIN("DOMAIN_PASSWORD_SIGNIN"),
    DOMAIN_SMART_CARD_SIGNIN("DOMAIN_SMART_CARD_SIGNIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Action(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Action fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Action.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Action> knownValues() {
        return Stream.of(Action.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

