/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.AppVisibility;
import software.amazon.awssdk.services.appstream.model.EntitlementAttribute;
import software.amazon.awssdk.services.appstream.model.EntitlementAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEntitlementRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateEntitlementRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateEntitlementRequest.getter(UpdateEntitlementRequest::name)).setter(UpdateEntitlementRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(UpdateEntitlementRequest.getter(UpdateEntitlementRequest::stackName)).setter(UpdateEntitlementRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateEntitlementRequest.getter(UpdateEntitlementRequest::description)).setter(UpdateEntitlementRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> APP_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppVisibility").getter(UpdateEntitlementRequest.getter(UpdateEntitlementRequest::appVisibilityAsString)).setter(UpdateEntitlementRequest.setter(Builder::appVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppVisibility").build()}).build();
    private static final SdkField<List<EntitlementAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(UpdateEntitlementRequest.getter(UpdateEntitlementRequest::attributes)).setter(UpdateEntitlementRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitlementAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STACK_NAME_FIELD, DESCRIPTION_FIELD, APP_VISIBILITY_FIELD, ATTRIBUTES_FIELD));
    private final String name;
    private final String stackName;
    private final String description;
    private final String appVisibility;
    private final List<EntitlementAttribute> attributes;

    private UpdateEntitlementRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.stackName = builder.stackName;
        this.description = builder.description;
        this.appVisibility = builder.appVisibility;
        this.attributes = builder.attributes;
    }

    public final String name() {
        return this.name;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String description() {
        return this.description;
    }

    public final AppVisibility appVisibility() {
        return AppVisibility.fromValue(this.appVisibility);
    }

    public final String appVisibilityAsString() {
        return this.appVisibility;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<EntitlementAttribute> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEntitlementRequest)) {
            return false;
        }
        UpdateEntitlementRequest other = (UpdateEntitlementRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.appVisibilityAsString(), other.appVisibilityAsString()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEntitlementRequest").add("Name", (Object)this.name()).add("StackName", (Object)this.stackName()).add("Description", (Object)this.description()).add("AppVisibility", (Object)this.appVisibilityAsString()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AppVisibility": {
                return Optional.ofNullable(clazz.cast(this.appVisibilityAsString()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEntitlementRequest, T> g) {
        return obj -> g.apply((UpdateEntitlementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String stackName;
        private String description;
        private String appVisibility;
        private List<EntitlementAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEntitlementRequest model) {
            super(model);
            this.name(model.name);
            this.stackName(model.stackName);
            this.description(model.description);
            this.appVisibility(model.appVisibility);
            this.attributes(model.attributes);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAppVisibility() {
            return this.appVisibility;
        }

        public final void setAppVisibility(String appVisibility) {
            this.appVisibility = appVisibility;
        }

        @Override
        @Transient
        public final Builder appVisibility(String appVisibility) {
            this.appVisibility = appVisibility;
            return this;
        }

        @Override
        @Transient
        public final Builder appVisibility(AppVisibility appVisibility) {
            this.appVisibility(appVisibility == null ? null : appVisibility.toString());
            return this;
        }

        public final List<EntitlementAttribute.Builder> getAttributes() {
            List<EntitlementAttribute.Builder> result = EntitlementAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<EntitlementAttribute.BuilderImpl> attributes) {
            this.attributes = EntitlementAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        @Transient
        public final Builder attributes(Collection<EntitlementAttribute> attributes) {
            this.attributes = EntitlementAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(EntitlementAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributes(Consumer<EntitlementAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (EntitlementAttribute)((EntitlementAttribute.Builder)EntitlementAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEntitlementRequest build() {
            return new UpdateEntitlementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEntitlementRequest> {
        public Builder name(String var1);

        public Builder stackName(String var1);

        public Builder description(String var1);

        public Builder appVisibility(String var1);

        public Builder appVisibility(AppVisibility var1);

        public Builder attributes(Collection<EntitlementAttribute> var1);

        public Builder attributes(EntitlementAttribute ... var1);

        public Builder attributes(Consumer<EntitlementAttribute.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

