/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.MetadataCopier;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.PlatformsCopier;
import software.amazon.awssdk.services.appstream.model.S3Location;
import software.amazon.awssdk.services.appstream.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Application
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Application> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Application.getter(Application::name)).setter(Application.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(Application.getter(Application::displayName)).setter(Application.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IconURL").getter(Application.getter(Application::iconURL)).setter(Application.setter(Builder::iconURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconURL").build()}).build();
    private static final SdkField<String> LAUNCH_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchPath").getter(Application.getter(Application::launchPath)).setter(Application.setter(Builder::launchPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPath").build()}).build();
    private static final SdkField<String> LAUNCH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchParameters").getter(Application.getter(Application::launchParameters)).setter(Application.setter(Builder::launchParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchParameters").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(Application.getter(Application::enabled)).setter(Application.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metadata").getter(Application.getter(Application::metadata)).setter(Application.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkingDirectory").getter(Application.getter(Application::workingDirectory)).setter(Application.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Application.getter(Application::description)).setter(Application.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Application.getter(Application::arn)).setter(Application.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> APP_BLOCK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppBlockArn").getter(Application.getter(Application::appBlockArn)).setter(Application.setter(Builder::appBlockArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockArn").build()}).build();
    private static final SdkField<S3Location> ICON_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IconS3Location").getter(Application.getter(Application::iconS3Location)).setter(Application.setter(Builder::iconS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconS3Location").build()}).build();
    private static final SdkField<List<String>> PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Platforms").getter(Application.getter(Application::platformsAsStrings)).setter(Application.setter(Builder::platformsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_FAMILIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceFamilies").getter(Application.getter(Application::instanceFamilies)).setter(Application.setter(Builder::instanceFamilies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamilies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Application.getter(Application::createdTime)).setter(Application.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DISPLAY_NAME_FIELD, ICON_URL_FIELD, LAUNCH_PATH_FIELD, LAUNCH_PARAMETERS_FIELD, ENABLED_FIELD, METADATA_FIELD, WORKING_DIRECTORY_FIELD, DESCRIPTION_FIELD, ARN_FIELD, APP_BLOCK_ARN_FIELD, ICON_S3_LOCATION_FIELD, PLATFORMS_FIELD, INSTANCE_FAMILIES_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String displayName;
    private final String iconURL;
    private final String launchPath;
    private final String launchParameters;
    private final Boolean enabled;
    private final Map<String, String> metadata;
    private final String workingDirectory;
    private final String description;
    private final String arn;
    private final String appBlockArn;
    private final S3Location iconS3Location;
    private final List<String> platforms;
    private final List<String> instanceFamilies;
    private final Instant createdTime;

    private Application(BuilderImpl builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.iconURL = builder.iconURL;
        this.launchPath = builder.launchPath;
        this.launchParameters = builder.launchParameters;
        this.enabled = builder.enabled;
        this.metadata = builder.metadata;
        this.workingDirectory = builder.workingDirectory;
        this.description = builder.description;
        this.arn = builder.arn;
        this.appBlockArn = builder.appBlockArn;
        this.iconS3Location = builder.iconS3Location;
        this.platforms = builder.platforms;
        this.instanceFamilies = builder.instanceFamilies;
        this.createdTime = builder.createdTime;
    }

    public final String name() {
        return this.name;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String iconURL() {
        return this.iconURL;
    }

    public final String launchPath() {
        return this.launchPath;
    }

    public final String launchParameters() {
        return this.launchParameters;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final String description() {
        return this.description;
    }

    public final String arn() {
        return this.arn;
    }

    public final String appBlockArn() {
        return this.appBlockArn;
    }

    public final S3Location iconS3Location() {
        return this.iconS3Location;
    }

    public final List<PlatformType> platforms() {
        return PlatformsCopier.copyStringToEnum(this.platforms);
    }

    public final boolean hasPlatforms() {
        return this.platforms != null && !(this.platforms instanceof SdkAutoConstructList);
    }

    public final List<String> platformsAsStrings() {
        return this.platforms;
    }

    public final boolean hasInstanceFamilies() {
        return this.instanceFamilies != null && !(this.instanceFamilies instanceof SdkAutoConstructList);
    }

    public final List<String> instanceFamilies() {
        return this.instanceFamilies;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appBlockArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatforms() ? this.platformsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceFamilies() ? this.instanceFamilies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.iconURL(), other.iconURL()) && Objects.equals(this.launchPath(), other.launchPath()) && Objects.equals(this.launchParameters(), other.launchParameters()) && Objects.equals(this.enabled(), other.enabled()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.appBlockArn(), other.appBlockArn()) && Objects.equals(this.iconS3Location(), other.iconS3Location()) && this.hasPlatforms() == other.hasPlatforms() && Objects.equals(this.platformsAsStrings(), other.platformsAsStrings()) && this.hasInstanceFamilies() == other.hasInstanceFamilies() && Objects.equals(this.instanceFamilies(), other.instanceFamilies()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"Application").add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("IconURL", (Object)this.iconURL()).add("LaunchPath", (Object)this.launchPath()).add("LaunchParameters", (Object)this.launchParameters()).add("Enabled", (Object)this.enabled()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("WorkingDirectory", (Object)this.workingDirectory()).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).add("AppBlockArn", (Object)this.appBlockArn()).add("IconS3Location", (Object)this.iconS3Location()).add("Platforms", this.hasPlatforms() ? this.platformsAsStrings() : null).add("InstanceFamilies", this.hasInstanceFamilies() ? this.instanceFamilies() : null).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "IconURL": {
                return Optional.ofNullable(clazz.cast(this.iconURL()));
            }
            case "LaunchPath": {
                return Optional.ofNullable(clazz.cast(this.launchPath()));
            }
            case "LaunchParameters": {
                return Optional.ofNullable(clazz.cast(this.launchParameters()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "WorkingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AppBlockArn": {
                return Optional.ofNullable(clazz.cast(this.appBlockArn()));
            }
            case "IconS3Location": {
                return Optional.ofNullable(clazz.cast(this.iconS3Location()));
            }
            case "Platforms": {
                return Optional.ofNullable(clazz.cast(this.platformsAsStrings()));
            }
            case "InstanceFamilies": {
                return Optional.ofNullable(clazz.cast(this.instanceFamilies()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String displayName;
        private String iconURL;
        private String launchPath;
        private String launchParameters;
        private Boolean enabled;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String workingDirectory;
        private String description;
        private String arn;
        private String appBlockArn;
        private S3Location iconS3Location;
        private List<String> platforms = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceFamilies = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            this.name(model.name);
            this.displayName(model.displayName);
            this.iconURL(model.iconURL);
            this.launchPath(model.launchPath);
            this.launchParameters(model.launchParameters);
            this.enabled(model.enabled);
            this.metadata(model.metadata);
            this.workingDirectory(model.workingDirectory);
            this.description(model.description);
            this.arn(model.arn);
            this.appBlockArn(model.appBlockArn);
            this.iconS3Location(model.iconS3Location);
            this.platformsWithStrings(model.platforms);
            this.instanceFamilies(model.instanceFamilies);
            this.createdTime(model.createdTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getIconURL() {
            return this.iconURL;
        }

        public final void setIconURL(String iconURL) {
            this.iconURL = iconURL;
        }

        @Override
        @Transient
        public final Builder iconURL(String iconURL) {
            this.iconURL = iconURL;
            return this;
        }

        public final String getLaunchPath() {
            return this.launchPath;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        @Override
        @Transient
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final String getLaunchParameters() {
            return this.launchParameters;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        @Override
        @Transient
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        @Override
        @Transient
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        @Transient
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAppBlockArn() {
            return this.appBlockArn;
        }

        public final void setAppBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
        }

        @Override
        @Transient
        public final Builder appBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
            return this;
        }

        public final S3Location.Builder getIconS3Location() {
            return this.iconS3Location != null ? this.iconS3Location.toBuilder() : null;
        }

        public final void setIconS3Location(S3Location.BuilderImpl iconS3Location) {
            this.iconS3Location = iconS3Location != null ? iconS3Location.build() : null;
        }

        @Override
        @Transient
        public final Builder iconS3Location(S3Location iconS3Location) {
            this.iconS3Location = iconS3Location;
            return this;
        }

        public final Collection<String> getPlatforms() {
            if (this.platforms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platforms;
        }

        public final void setPlatforms(Collection<String> platforms) {
            this.platforms = PlatformsCopier.copy(platforms);
        }

        @Override
        @Transient
        public final Builder platformsWithStrings(Collection<String> platforms) {
            this.platforms = PlatformsCopier.copy(platforms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder platformsWithStrings(String ... platforms) {
            this.platformsWithStrings(Arrays.asList(platforms));
            return this;
        }

        @Override
        @Transient
        public final Builder platforms(Collection<PlatformType> platforms) {
            this.platforms = PlatformsCopier.copyEnumToString(platforms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder platforms(PlatformType ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        public final Collection<String> getInstanceFamilies() {
            if (this.instanceFamilies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceFamilies;
        }

        public final void setInstanceFamilies(Collection<String> instanceFamilies) {
            this.instanceFamilies = StringListCopier.copy(instanceFamilies);
        }

        @Override
        @Transient
        public final Builder instanceFamilies(Collection<String> instanceFamilies) {
            this.instanceFamilies = StringListCopier.copy(instanceFamilies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceFamilies(String ... instanceFamilies) {
            this.instanceFamilies(Arrays.asList(instanceFamilies));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public Application build() {
            return new Application(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Application> {
        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder iconURL(String var1);

        public Builder launchPath(String var1);

        public Builder launchParameters(String var1);

        public Builder enabled(Boolean var1);

        public Builder metadata(Map<String, String> var1);

        public Builder workingDirectory(String var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder appBlockArn(String var1);

        public Builder iconS3Location(S3Location var1);

        default public Builder iconS3Location(Consumer<S3Location.Builder> iconS3Location) {
            return this.iconS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(iconS3Location)).build());
        }

        public Builder platformsWithStrings(Collection<String> var1);

        public Builder platformsWithStrings(String ... var1);

        public Builder platforms(Collection<PlatformType> var1);

        public Builder platforms(PlatformType ... var1);

        public Builder instanceFamilies(Collection<String> var1);

        public Builder instanceFamilies(String ... var1);

        public Builder createdTime(Instant var1);
    }
}

