/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeSessionsRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackName").isBinary(false).build();
    private static final MarshallingInfo<String> FLEETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetName").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHENTICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthenticationType").isBinary(false).build();
    private static final DescribeSessionsRequestModelMarshaller INSTANCE = new DescribeSessionsRequestModelMarshaller();

    private DescribeSessionsRequestModelMarshaller() {
    }

    public static DescribeSessionsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeSessionsRequest describeSessionsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeSessionsRequest), (String)"describeSessionsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeSessionsRequest.stackName(), STACKNAME_BINDING);
            protocolMarshaller.marshall((Object)describeSessionsRequest.fleetName(), FLEETNAME_BINDING);
            protocolMarshaller.marshall((Object)describeSessionsRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)describeSessionsRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeSessionsRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)describeSessionsRequest.authenticationTypeString(), AUTHENTICATIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

