/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.CreateStreamingURLRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateStreamingURLRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackName").isBinary(false).build();
    private static final MarshallingInfo<String> FLEETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetName").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").isBinary(false).build();
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<Long> VALIDITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Validity").isBinary(false).build();
    private static final MarshallingInfo<String> SESSIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SessionContext").isBinary(false).build();
    private static final CreateStreamingURLRequestModelMarshaller INSTANCE = new CreateStreamingURLRequestModelMarshaller();

    private CreateStreamingURLRequestModelMarshaller() {
    }

    public static CreateStreamingURLRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateStreamingURLRequest createStreamingURLRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createStreamingURLRequest), (String)"createStreamingURLRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createStreamingURLRequest.stackName(), STACKNAME_BINDING);
            protocolMarshaller.marshall((Object)createStreamingURLRequest.fleetName(), FLEETNAME_BINDING);
            protocolMarshaller.marshall((Object)createStreamingURLRequest.userId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)createStreamingURLRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)createStreamingURLRequest.validity(), VALIDITY_BINDING);
            protocolMarshaller.marshall((Object)createStreamingURLRequest.sessionContext(), SESSIONCONTEXT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

