/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.Session;
import software.amazon.awssdk.services.appstream.model.SessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSessionsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeSessionsResponse> {
    private final List<Session> sessions;
    private final String nextToken;

    private DescribeSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.sessions = builder.sessions;
        this.nextToken = builder.nextToken;
    }

    public List<Session> sessions() {
        return this.sessions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSessionsResponse)) {
            return false;
        }
        DescribeSessionsResponse other = (DescribeSessionsResponse)((Object)obj);
        return Objects.equals(this.sessions(), other.sessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSessionsResponse").add("Sessions", this.sessions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sessions": {
                return Optional.of(clazz.cast(this.sessions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<Session> sessions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSessionsResponse model) {
            this.sessions(model.sessions);
            this.nextToken(model.nextToken);
        }

        public final Collection<Session.Builder> getSessions() {
            return this.sessions != null ? (Collection)this.sessions.stream().map(Session::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sessions(Collection<Session> sessions) {
            this.sessions = SessionListCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Session ... sessions) {
            this.sessions(Arrays.asList(sessions));
            return this;
        }

        public final void setSessions(Collection<Session.BuilderImpl> sessions) {
            this.sessions = SessionListCopier.copyFromBuilder(sessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSessionsResponse build() {
            return new DescribeSessionsResponse(this);
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    CopyableBuilder<Builder, DescribeSessionsResponse> {
        public Builder sessions(Collection<Session> var1);

        public Builder sessions(Session ... var1);

        public Builder nextToken(String var1);
    }
}

