/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateStackRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateStackRequest> {
    private final String displayName;
    private final String description;
    private final String name;
    private final List<StorageConnector> storageConnectors;
    private final Boolean deleteStorageConnectors;

    private UpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.name = builder.name;
        this.storageConnectors = builder.storageConnectors;
        this.deleteStorageConnectors = builder.deleteStorageConnectors;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public Boolean deleteStorageConnectors() {
        return this.deleteStorageConnectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteStorageConnectors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.storageConnectors(), other.storageConnectors()) && Objects.equals(this.deleteStorageConnectors(), other.deleteStorageConnectors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.storageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.storageConnectors()).append(",");
        }
        if (this.deleteStorageConnectors() != null) {
            sb.append("DeleteStorageConnectors: ").append(this.deleteStorageConnectors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "StorageConnectors": {
                return Optional.of(clazz.cast(this.storageConnectors()));
            }
            case "DeleteStorageConnectors": {
                return Optional.of(clazz.cast(this.deleteStorageConnectors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String displayName;
        private String description;
        private String name;
        private List<StorageConnector> storageConnectors;
        private Boolean deleteStorageConnectors;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            this.displayName(model.displayName);
            this.description(model.description);
            this.name(model.name);
            this.storageConnectors(model.storageConnectors);
            this.deleteStorageConnectors(model.deleteStorageConnectors);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return this.storageConnectors != null ? (Collection)this.storageConnectors.stream().map(StorageConnector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final Boolean getDeleteStorageConnectors() {
            return this.deleteStorageConnectors;
        }

        @Override
        public final Builder deleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
            return this;
        }

        public final void setDeleteStorageConnectors(Boolean deleteStorageConnectors) {
            this.deleteStorageConnectors = deleteStorageConnectors;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, UpdateStackRequest> {
        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder deleteStorageConnectors(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

