/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.StackError;
import software.amazon.awssdk.services.appstream.model.StackErrorsCopier;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.services.appstream.transform.StackMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Stack
implements StructuredPojo,
ToCopyableBuilder<Builder, Stack> {
    private final String arn;
    private final String name;
    private final String description;
    private final String displayName;
    private final Instant createdTime;
    private final List<StorageConnector> storageConnectors;
    private final List<StackError> stackErrors;

    private Stack(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.createdTime = builder.createdTime;
        this.storageConnectors = builder.storageConnectors;
        this.stackErrors = builder.stackErrors;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public List<StackError> stackErrors() {
        return this.stackErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.storageConnectors() == null ? 0 : this.storageConnectors().hashCode());
        hashCode = 31 * hashCode + (this.stackErrors() == null ? 0 : this.stackErrors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.storageConnectors() == null ^ this.storageConnectors() == null) {
            return false;
        }
        if (other.storageConnectors() != null && !other.storageConnectors().equals(this.storageConnectors())) {
            return false;
        }
        if (other.stackErrors() == null ^ this.stackErrors() == null) {
            return false;
        }
        return other.stackErrors() == null || other.stackErrors().equals(this.stackErrors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.storageConnectors() != null) {
            sb.append("StorageConnectors: ").append(this.storageConnectors()).append(",");
        }
        if (this.stackErrors() != null) {
            sb.append("StackErrors: ").append(this.stackErrors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String displayName;
        private Instant createdTime;
        private List<StorageConnector> storageConnectors;
        private List<StackError> stackErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            this.setArn(model.arn);
            this.setName(model.name);
            this.setDescription(model.description);
            this.setDisplayName(model.displayName);
            this.setCreatedTime(model.createdTime);
            this.setStorageConnectors(model.storageConnectors);
            this.setStackErrors(model.stackErrors);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<StorageConnector> getStorageConnectors() {
            return this.storageConnectors;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
        }

        public final Collection<StackError> getStackErrors() {
            return this.stackErrors;
        }

        @Override
        public final Builder stackErrors(Collection<StackError> stackErrors) {
            this.stackErrors = StackErrorsCopier.copy(stackErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackErrors(StackError ... stackErrors) {
            this.stackErrors(Arrays.asList(stackErrors));
            return this;
        }

        public final void setStackErrors(Collection<StackError> stackErrors) {
            this.stackErrors = StackErrorsCopier.copy(stackErrors);
        }

        public Stack build() {
            return new Stack(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Stack> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder createdTime(Instant var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder stackErrors(Collection<StackError> var1);

        public Builder stackErrors(StackError ... var1);
    }
}

