/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.appstream.AppStreamClient;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.appstream.waiters.DescribeFleetsFunction;
import software.amazon.awssdk.services.appstream.waiters.FleetStarted;
import software.amazon.awssdk.services.appstream.waiters.FleetStopped;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class AppStreamClientWaiters {
    private final AppStreamClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AppStreamClientWaiters(AppStreamClient client) {
        this.client = client;
    }

    public Waiter<DescribeFleetsRequest> fleetStarted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeFleetsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new FleetStarted.IsACTIVEMatcher(), new FleetStarted.IsPENDING_DEACTIVATEMatcher(), new FleetStarted.IsINACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeFleetsRequest> fleetStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeFleetsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new FleetStopped.IsINACTIVEMatcher(), new FleetStopped.IsPENDING_ACTIVATEMatcher(), new FleetStopped.IsACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

