/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import java.util.Date;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.Fleet;

@SdkInternalApi
public class FleetMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> IMAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageName").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<StructuredPojo> COMPUTECAPACITYSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeCapacityStatus").build();
    private static final MarshallingInfo<Integer> MAXUSERDURATIONINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxUserDurationInSeconds").build();
    private static final MarshallingInfo<Integer> DISCONNECTTIMEOUTINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisconnectTimeoutInSeconds").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfig").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").build();
    private static final MarshallingInfo<List> FLEETERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetErrors").build();
    private static final MarshallingInfo<Boolean> ENABLEDEFAULTINTERNETACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableDefaultInternetAccess").build();
    private static final FleetMarshaller instance = new FleetMarshaller();

    public static FleetMarshaller getInstance() {
        return instance;
    }

    public void marshall(Fleet fleet, ProtocolMarshaller protocolMarshaller) {
        if (fleet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fleet.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)fleet.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)fleet.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)fleet.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)fleet.imageName(), IMAGENAME_BINDING);
            protocolMarshaller.marshall((Object)fleet.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)fleet.computeCapacityStatus(), COMPUTECAPACITYSTATUS_BINDING);
            protocolMarshaller.marshall((Object)fleet.maxUserDurationInSeconds(), MAXUSERDURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)fleet.disconnectTimeoutInSeconds(), DISCONNECTTIMEOUTINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)fleet.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)fleet.vpcConfig(), VPCCONFIG_BINDING);
            protocolMarshaller.marshall((Object)fleet.createdTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall(fleet.fleetErrors(), FLEETERRORS_BINDING);
            protocolMarshaller.marshall((Object)fleet.enableDefaultInternetAccess(), ENABLEDEFAULTINTERNETACCESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

