/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.AuthenticationType;
import software.amazon.awssdk.services.appstream.model.SessionState;
import software.amazon.awssdk.services.appstream.transform.SessionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Session
implements StructuredPojo,
ToCopyableBuilder<Builder, Session> {
    private final String id;
    private final String userId;
    private final String stackName;
    private final String fleetName;
    private final String state;
    private final String authenticationType;

    private Session(BuilderImpl builder) {
        this.id = builder.id;
        this.userId = builder.userId;
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.state = builder.state;
        this.authenticationType = builder.authenticationType;
    }

    public String id() {
        return this.id;
    }

    public String userId() {
        return this.userId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public String state() {
        return this.state;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.userId() == null ? 0 : this.userId().hashCode());
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.fleetName() == null ? 0 : this.fleetName().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.authenticationType() == null ? 0 : this.authenticationType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        if (other.userId() != null && !other.userId().equals(this.userId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.fleetName() == null ^ this.fleetName() == null) {
            return false;
        }
        if (other.fleetName() != null && !other.fleetName().equals(this.fleetName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.authenticationType() == null ^ this.authenticationType() == null) {
            return false;
        }
        return other.authenticationType() == null || other.authenticationType().equals(this.authenticationType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.fleetName() != null) {
            sb.append("FleetName: ").append(this.fleetName()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.authenticationType() != null) {
            sb.append("AuthenticationType: ").append(this.authenticationType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String userId;
        private String stackName;
        private String fleetName;
        private String state;
        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.setId(model.id);
            this.setUserId(model.userId);
            this.setStackName(model.stackName);
            this.setFleetName(model.fleetName);
            this.setState(model.state);
            this.setAuthenticationType(model.authenticationType);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SessionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(SessionState state) {
            this.state(state.toString());
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final void setAuthenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
        }

        public Session build() {
            return new Session(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Session> {
        public Builder id(String var1);

        public Builder userId(String var1);

        public Builder stackName(String var1);

        public Builder fleetName(String var1);

        public Builder state(String var1);

        public Builder state(SessionState var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);
    }
}

