/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest;
import software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse;

public class ListServicesForAutoScalingConfigurationIterable
implements SdkIterable<ListServicesForAutoScalingConfigurationResponse> {
    private final AppRunnerClient client;
    private final ListServicesForAutoScalingConfigurationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServicesForAutoScalingConfigurationIterable(AppRunnerClient client, ListServicesForAutoScalingConfigurationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServicesForAutoScalingConfigurationResponseFetcher();
    }

    public Iterator<ListServicesForAutoScalingConfigurationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListServicesForAutoScalingConfigurationResponseFetcher
    implements SyncPageFetcher<ListServicesForAutoScalingConfigurationResponse> {
        private ListServicesForAutoScalingConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesForAutoScalingConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServicesForAutoScalingConfigurationResponse nextPage(ListServicesForAutoScalingConfigurationResponse previousPage) {
            if (previousPage == null) {
                return ListServicesForAutoScalingConfigurationIterable.this.client.listServicesForAutoScalingConfiguration(ListServicesForAutoScalingConfigurationIterable.this.firstRequest);
            }
            return ListServicesForAutoScalingConfigurationIterable.this.client.listServicesForAutoScalingConfiguration((ListServicesForAutoScalingConfigurationRequest)((Object)ListServicesForAutoScalingConfigurationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

