/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationType {
    START_DEPLOYMENT("START_DEPLOYMENT"),
    CREATE_SERVICE("CREATE_SERVICE"),
    PAUSE_SERVICE("PAUSE_SERVICE"),
    RESUME_SERVICE("RESUME_SERVICE"),
    DELETE_SERVICE("DELETE_SERVICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationType> VALUE_MAP;
    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationType> knownValues() {
        EnumSet<OperationType> knownValues = EnumSet.allOf(OperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationType.class, OperationType::toString);
    }
}

