/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceConfiguration> {
    private static final SdkField<String> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cpu").getter(InstanceConfiguration.getter(InstanceConfiguration::cpu)).setter(InstanceConfiguration.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()}).build();
    private static final SdkField<String> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Memory").getter(InstanceConfiguration.getter(InstanceConfiguration::memory)).setter(InstanceConfiguration.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRoleArn").getter(InstanceConfiguration.getter(InstanceConfiguration::instanceRoleArn)).setter(InstanceConfiguration.setter(Builder::instanceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_FIELD, MEMORY_FIELD, INSTANCE_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cpu;
    private final String memory;
    private final String instanceRoleArn;

    private InstanceConfiguration(BuilderImpl builder) {
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.instanceRoleArn = builder.instanceRoleArn;
    }

    public final String cpu() {
        return this.cpu;
    }

    public final String memory() {
        return this.memory;
    }

    public final String instanceRoleArn() {
        return this.instanceRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceConfiguration)) {
            return false;
        }
        InstanceConfiguration other = (InstanceConfiguration)obj;
        return Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.instanceRoleArn(), other.instanceRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceConfiguration").add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("InstanceRoleArn", (Object)this.instanceRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "Memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "InstanceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.instanceRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceConfiguration, T> g) {
        return obj -> g.apply((InstanceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cpu;
        private String memory;
        private String instanceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceConfiguration model) {
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.instanceRoleArn(model.instanceRoleArn);
        }

        public final String getCpu() {
            return this.cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        @Transient
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return this.memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        @Transient
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final String getInstanceRoleArn() {
            return this.instanceRoleArn;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        @Override
        @Transient
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public InstanceConfiguration build() {
            return new InstanceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceConfiguration> {
        public Builder cpu(String var1);

        public Builder memory(String var1);

        public Builder instanceRoleArn(String var1);
    }
}

