/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerRequest;
import software.amazon.awssdk.services.apprunner.model.EncryptionConfiguration;
import software.amazon.awssdk.services.apprunner.model.HealthCheckConfiguration;
import software.amazon.awssdk.services.apprunner.model.InstanceConfiguration;
import software.amazon.awssdk.services.apprunner.model.SourceConfiguration;
import software.amazon.awssdk.services.apprunner.model.Tag;
import software.amazon.awssdk.services.apprunner.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceRequest
extends AppRunnerRequest
implements ToCopyableBuilder<Builder, CreateServiceRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(CreateServiceRequest.getter(CreateServiceRequest::serviceName)).setter(CreateServiceRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConfiguration").getter(CreateServiceRequest.getter(CreateServiceRequest::sourceConfiguration)).setter(CreateServiceRequest.setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build()}).build();
    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceConfiguration").getter(CreateServiceRequest.getter(CreateServiceRequest::instanceConfiguration)).setter(CreateServiceRequest.setter(Builder::instanceConfiguration)).constructor(InstanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateServiceRequest.getter(CreateServiceRequest::tags)).setter(CreateServiceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(CreateServiceRequest.getter(CreateServiceRequest::encryptionConfiguration)).setter(CreateServiceRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<HealthCheckConfiguration> HEALTH_CHECK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheckConfiguration").getter(CreateServiceRequest.getter(CreateServiceRequest::healthCheckConfiguration)).setter(CreateServiceRequest.setter(Builder::healthCheckConfiguration)).constructor(HealthCheckConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfiguration").build()}).build();
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingConfigurationArn").getter(CreateServiceRequest.getter(CreateServiceRequest::autoScalingConfigurationArn)).setter(CreateServiceRequest.setter(Builder::autoScalingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, SOURCE_CONFIGURATION_FIELD, INSTANCE_CONFIGURATION_FIELD, TAGS_FIELD, ENCRYPTION_CONFIGURATION_FIELD, HEALTH_CHECK_CONFIGURATION_FIELD, AUTO_SCALING_CONFIGURATION_ARN_FIELD));
    private final String serviceName;
    private final SourceConfiguration sourceConfiguration;
    private final InstanceConfiguration instanceConfiguration;
    private final List<Tag> tags;
    private final EncryptionConfiguration encryptionConfiguration;
    private final HealthCheckConfiguration healthCheckConfiguration;
    private final String autoScalingConfigurationArn;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.tags = builder.tags;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.healthCheckConfiguration = builder.healthCheckConfiguration;
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final SourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public final InstanceConfiguration instanceConfiguration() {
        return this.instanceConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final HealthCheckConfiguration healthCheckConfiguration() {
        return this.healthCheckConfiguration;
    }

    public final String autoScalingConfigurationArn() {
        return this.autoScalingConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)((Object)obj);
        return Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration()) && Objects.equals(this.instanceConfiguration(), other.instanceConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.healthCheckConfiguration(), other.healthCheckConfiguration()) && Objects.equals(this.autoScalingConfigurationArn(), other.autoScalingConfigurationArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceRequest").add("ServiceName", (Object)this.serviceName()).add("SourceConfiguration", (Object)this.sourceConfiguration()).add("InstanceConfiguration", (Object)this.instanceConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("HealthCheckConfiguration", (Object)this.healthCheckConfiguration()).add("AutoScalingConfigurationArn", (Object)this.autoScalingConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "SourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
            case "InstanceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "HealthCheckConfiguration": {
                return Optional.ofNullable(clazz.cast(this.healthCheckConfiguration()));
            }
            case "AutoScalingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerRequest.BuilderImpl
    implements Builder {
        private String serviceName;
        private SourceConfiguration sourceConfiguration;
        private InstanceConfiguration instanceConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private EncryptionConfiguration encryptionConfiguration;
        private HealthCheckConfiguration healthCheckConfiguration;
        private String autoScalingConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            this.serviceName(model.serviceName);
            this.sourceConfiguration(model.sourceConfiguration);
            this.instanceConfiguration(model.instanceConfiguration);
            this.tags(model.tags);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.healthCheckConfiguration(model.healthCheckConfiguration);
            this.autoScalingConfigurationArn(model.autoScalingConfigurationArn);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return this.instanceConfiguration != null ? this.instanceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public final HealthCheckConfiguration.Builder getHealthCheckConfiguration() {
            return this.healthCheckConfiguration != null ? this.healthCheckConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfiguration(HealthCheckConfiguration healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration;
            return this;
        }

        public final void setHealthCheckConfiguration(HealthCheckConfiguration.BuilderImpl healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration != null ? healthCheckConfiguration.build() : null;
        }

        public final String getAutoScalingConfigurationArn() {
            return this.autoScalingConfigurationArn;
        }

        @Override
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceRequest> {
        public Builder serviceName(String var1);

        public Builder sourceConfiguration(SourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((SourceConfiguration)((SourceConfiguration.Builder)SourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }

        public Builder instanceConfiguration(InstanceConfiguration var1);

        default public Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return this.instanceConfiguration((InstanceConfiguration)((InstanceConfiguration.Builder)InstanceConfiguration.builder().applyMutation(instanceConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder healthCheckConfiguration(HealthCheckConfiguration var1);

        default public Builder healthCheckConfiguration(Consumer<HealthCheckConfiguration.Builder> healthCheckConfiguration) {
            return this.healthCheckConfiguration((HealthCheckConfiguration)((HealthCheckConfiguration.Builder)HealthCheckConfiguration.builder().applyMutation(healthCheckConfiguration)).build());
        }

        public Builder autoScalingConfigurationArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

