/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterListener;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterListenersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualRouterSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualRouterSpec> {
    private static final SdkField<List<VirtualRouterListener>> LISTENERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VirtualRouterSpec.getter(VirtualRouterSpec::listeners)).setter(VirtualRouterSpec.setter(Builder::listeners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listeners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualRouterListener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<VirtualRouterListener> listeners;

    private VirtualRouterSpec(BuilderImpl builder) {
        this.listeners = builder.listeners;
    }

    public List<VirtualRouterListener> listeners() {
        return this.listeners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listeners());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualRouterSpec)) {
            return false;
        }
        VirtualRouterSpec other = (VirtualRouterSpec)obj;
        return Objects.equals(this.listeners(), other.listeners());
    }

    public String toString() {
        return ToString.builder((String)"VirtualRouterSpec").add("Listeners", this.listeners()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "listeners": {
                return Optional.ofNullable(clazz.cast(this.listeners()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualRouterSpec, T> g) {
        return obj -> g.apply((VirtualRouterSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<VirtualRouterListener> listeners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualRouterSpec model) {
            this.listeners(model.listeners);
        }

        public final Collection<VirtualRouterListener.Builder> getListeners() {
            return this.listeners != null ? (Collection)this.listeners.stream().map(VirtualRouterListener::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listeners(Collection<VirtualRouterListener> listeners) {
            this.listeners = VirtualRouterListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(VirtualRouterListener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<VirtualRouterListener.Builder> ... listeners) {
            this.listeners(Stream.of(listeners).map(c -> (VirtualRouterListener)((VirtualRouterListener.Builder)VirtualRouterListener.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<VirtualRouterListener.BuilderImpl> listeners) {
            this.listeners = VirtualRouterListenersCopier.copyFromBuilder(listeners);
        }

        public VirtualRouterSpec build() {
            return new VirtualRouterSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualRouterSpec> {
        public Builder listeners(Collection<VirtualRouterListener> var1);

        public Builder listeners(VirtualRouterListener ... var1);

        public Builder listeners(Consumer<VirtualRouterListener.Builder> ... var1);
    }
}

