/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.ResourceMetadata;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeSpec;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualNodeData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualNodeData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualNodeData.getter(VirtualNodeData::meshName)).setter(VirtualNodeData.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VirtualNodeData.getter(VirtualNodeData::metadata)).setter(VirtualNodeData.setter(Builder::metadata)).constructor(ResourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<VirtualNodeSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VirtualNodeData.getter(VirtualNodeData::spec)).setter(VirtualNodeData.setter(Builder::spec)).constructor(VirtualNodeSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<VirtualNodeStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VirtualNodeData.getter(VirtualNodeData::status)).setter(VirtualNodeData.setter(Builder::status)).constructor(VirtualNodeStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VIRTUAL_NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VirtualNodeData.getter(VirtualNodeData::virtualNodeName)).setter(VirtualNodeData.setter(Builder::virtualNodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNodeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD, METADATA_FIELD, SPEC_FIELD, STATUS_FIELD, VIRTUAL_NODE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String meshName;
    private final ResourceMetadata metadata;
    private final VirtualNodeSpec spec;
    private final VirtualNodeStatus status;
    private final String virtualNodeName;

    private VirtualNodeData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
        this.virtualNodeName = builder.virtualNodeName;
    }

    public String meshName() {
        return this.meshName;
    }

    public ResourceMetadata metadata() {
        return this.metadata;
    }

    public VirtualNodeSpec spec() {
        return this.spec;
    }

    public VirtualNodeStatus status() {
        return this.status;
    }

    public String virtualNodeName() {
        return this.virtualNodeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNodeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeData)) {
            return false;
        }
        VirtualNodeData other = (VirtualNodeData)obj;
        return Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.virtualNodeName(), other.virtualNodeName());
    }

    public String toString() {
        return ToString.builder((String)"VirtualNodeData").add("MeshName", (Object)this.meshName()).add("Metadata", (Object)this.metadata()).add("Spec", (Object)this.spec()).add("Status", (Object)this.status()).add("VirtualNodeName", (Object)this.virtualNodeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "virtualNodeName": {
                return Optional.ofNullable(clazz.cast(this.virtualNodeName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeData, T> g) {
        return obj -> g.apply((VirtualNodeData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String meshName;
        private ResourceMetadata metadata;
        private VirtualNodeSpec spec;
        private VirtualNodeStatus status;
        private String virtualNodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeData model) {
            this.meshName(model.meshName);
            this.metadata(model.metadata);
            this.spec(model.spec);
            this.status(model.status);
            this.virtualNodeName(model.virtualNodeName);
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final VirtualNodeSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualNodeSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualNodeSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final VirtualNodeStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(VirtualNodeStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VirtualNodeStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getVirtualNodeName() {
            return this.virtualNodeName;
        }

        @Override
        public final Builder virtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        public final void setVirtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
        }

        public VirtualNodeData build() {
            return new VirtualNodeData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualNodeData> {
        public Builder meshName(String var1);

        public Builder metadata(ResourceMetadata var1);

        default public Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return this.metadata((ResourceMetadata)((ResourceMetadata.Builder)ResourceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder spec(VirtualNodeSpec var1);

        default public Builder spec(Consumer<VirtualNodeSpec.Builder> spec) {
            return this.spec((VirtualNodeSpec)((VirtualNodeSpec.Builder)VirtualNodeSpec.builder().applyMutation(spec)).build());
        }

        public Builder status(VirtualNodeStatus var1);

        default public Builder status(Consumer<VirtualNodeStatus.Builder> status) {
            return this.status((VirtualNodeStatus)((VirtualNodeStatus.Builder)VirtualNodeStatus.builder().applyMutation(status)).build());
        }

        public Builder virtualNodeName(String var1);
    }
}

