/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.HttpRoute;
import software.amazon.awssdk.services.appmesh.model.TcpRoute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteSpec> {
    private static final SdkField<HttpRoute> HTTP_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RouteSpec.getter(RouteSpec::httpRoute)).setter(RouteSpec.setter(Builder::httpRoute)).constructor(HttpRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRoute").build()}).build();
    private static final SdkField<TcpRoute> TCP_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RouteSpec.getter(RouteSpec::tcpRoute)).setter(RouteSpec.setter(Builder::tcpRoute)).constructor(TcpRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcpRoute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ROUTE_FIELD, TCP_ROUTE_FIELD));
    private static final long serialVersionUID = 1L;
    private final HttpRoute httpRoute;
    private final TcpRoute tcpRoute;

    private RouteSpec(BuilderImpl builder) {
        this.httpRoute = builder.httpRoute;
        this.tcpRoute = builder.tcpRoute;
    }

    public HttpRoute httpRoute() {
        return this.httpRoute;
    }

    public TcpRoute tcpRoute() {
        return this.tcpRoute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.tcpRoute());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSpec)) {
            return false;
        }
        RouteSpec other = (RouteSpec)obj;
        return Objects.equals(this.httpRoute(), other.httpRoute()) && Objects.equals(this.tcpRoute(), other.tcpRoute());
    }

    public String toString() {
        return ToString.builder((String)"RouteSpec").add("HttpRoute", (Object)this.httpRoute()).add("TcpRoute", (Object)this.tcpRoute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "httpRoute": {
                return Optional.ofNullable(clazz.cast(this.httpRoute()));
            }
            case "tcpRoute": {
                return Optional.ofNullable(clazz.cast(this.tcpRoute()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteSpec, T> g) {
        return obj -> g.apply((RouteSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HttpRoute httpRoute;
        private TcpRoute tcpRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSpec model) {
            this.httpRoute(model.httpRoute);
            this.tcpRoute(model.tcpRoute);
        }

        public final HttpRoute.Builder getHttpRoute() {
            return this.httpRoute != null ? this.httpRoute.toBuilder() : null;
        }

        @Override
        public final Builder httpRoute(HttpRoute httpRoute) {
            this.httpRoute = httpRoute;
            return this;
        }

        public final void setHttpRoute(HttpRoute.BuilderImpl httpRoute) {
            this.httpRoute = httpRoute != null ? httpRoute.build() : null;
        }

        public final TcpRoute.Builder getTcpRoute() {
            return this.tcpRoute != null ? this.tcpRoute.toBuilder() : null;
        }

        @Override
        public final Builder tcpRoute(TcpRoute tcpRoute) {
            this.tcpRoute = tcpRoute;
            return this;
        }

        public final void setTcpRoute(TcpRoute.BuilderImpl tcpRoute) {
            this.tcpRoute = tcpRoute != null ? tcpRoute.build() : null;
        }

        public RouteSpec build() {
            return new RouteSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteSpec> {
        public Builder httpRoute(HttpRoute var1);

        default public Builder httpRoute(Consumer<HttpRoute.Builder> httpRoute) {
            return this.httpRoute((HttpRoute)((HttpRoute.Builder)HttpRoute.builder().applyMutation(httpRoute)).build());
        }

        public Builder tcpRoute(TcpRoute var1);

        default public Builder tcpRoute(Consumer<TcpRoute.Builder> tcpRoute) {
            return this.tcpRoute((TcpRoute)((TcpRoute.Builder)TcpRoute.builder().applyMutation(tcpRoute)).build());
        }
    }
}

