/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeServiceProvider;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterServiceProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualServiceProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualServiceProvider> {
    private static final SdkField<VirtualNodeServiceProvider> VIRTUAL_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VirtualServiceProvider.getter(VirtualServiceProvider::virtualNode)).setter(VirtualServiceProvider.setter(Builder::virtualNode)).constructor(VirtualNodeServiceProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNode").build()}).build();
    private static final SdkField<VirtualRouterServiceProvider> VIRTUAL_ROUTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VirtualServiceProvider.getter(VirtualServiceProvider::virtualRouter)).setter(VirtualServiceProvider.setter(Builder::virtualRouter)).constructor(VirtualRouterServiceProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_NODE_FIELD, VIRTUAL_ROUTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final VirtualNodeServiceProvider virtualNode;
    private final VirtualRouterServiceProvider virtualRouter;

    private VirtualServiceProvider(BuilderImpl builder) {
        this.virtualNode = builder.virtualNode;
        this.virtualRouter = builder.virtualRouter;
    }

    public VirtualNodeServiceProvider virtualNode() {
        return this.virtualNode;
    }

    public VirtualRouterServiceProvider virtualRouter() {
        return this.virtualRouter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualRouter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualServiceProvider)) {
            return false;
        }
        VirtualServiceProvider other = (VirtualServiceProvider)obj;
        return Objects.equals(this.virtualNode(), other.virtualNode()) && Objects.equals(this.virtualRouter(), other.virtualRouter());
    }

    public String toString() {
        return ToString.builder((String)"VirtualServiceProvider").add("VirtualNode", (Object)this.virtualNode()).add("VirtualRouter", (Object)this.virtualRouter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualNode": {
                return Optional.ofNullable(clazz.cast(this.virtualNode()));
            }
            case "virtualRouter": {
                return Optional.ofNullable(clazz.cast(this.virtualRouter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualServiceProvider, T> g) {
        return obj -> g.apply((VirtualServiceProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VirtualNodeServiceProvider virtualNode;
        private VirtualRouterServiceProvider virtualRouter;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualServiceProvider model) {
            this.virtualNode(model.virtualNode);
            this.virtualRouter(model.virtualRouter);
        }

        public final VirtualNodeServiceProvider.Builder getVirtualNode() {
            return this.virtualNode != null ? this.virtualNode.toBuilder() : null;
        }

        @Override
        public final Builder virtualNode(VirtualNodeServiceProvider virtualNode) {
            this.virtualNode = virtualNode;
            return this;
        }

        public final void setVirtualNode(VirtualNodeServiceProvider.BuilderImpl virtualNode) {
            this.virtualNode = virtualNode != null ? virtualNode.build() : null;
        }

        public final VirtualRouterServiceProvider.Builder getVirtualRouter() {
            return this.virtualRouter != null ? this.virtualRouter.toBuilder() : null;
        }

        @Override
        public final Builder virtualRouter(VirtualRouterServiceProvider virtualRouter) {
            this.virtualRouter = virtualRouter;
            return this;
        }

        public final void setVirtualRouter(VirtualRouterServiceProvider.BuilderImpl virtualRouter) {
            this.virtualRouter = virtualRouter != null ? virtualRouter.build() : null;
        }

        public VirtualServiceProvider build() {
            return new VirtualServiceProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualServiceProvider> {
        public Builder virtualNode(VirtualNodeServiceProvider var1);

        default public Builder virtualNode(Consumer<VirtualNodeServiceProvider.Builder> virtualNode) {
            return this.virtualNode((VirtualNodeServiceProvider)((VirtualNodeServiceProvider.Builder)VirtualNodeServiceProvider.builder().applyMutation(virtualNode)).build());
        }

        public Builder virtualRouter(VirtualRouterServiceProvider var1);

        default public Builder virtualRouter(Consumer<VirtualRouterServiceProvider.Builder> virtualRouter) {
            return this.virtualRouter((VirtualRouterServiceProvider)((VirtualRouterServiceProvider.Builder)VirtualRouterServiceProvider.builder().applyMutation(virtualRouter)).build());
        }
    }
}

