/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.appmesh.AppMeshClient;
import software.amazon.awssdk.services.appmesh.AppMeshServiceClientConfiguration;
import software.amazon.awssdk.services.appmesh.internal.AppMeshServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.appmesh.model.AppMeshException;
import software.amazon.awssdk.services.appmesh.model.BadRequestException;
import software.amazon.awssdk.services.appmesh.model.ConflictException;
import software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.CreateGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.CreateMeshRequest;
import software.amazon.awssdk.services.appmesh.model.CreateMeshResponse;
import software.amazon.awssdk.services.appmesh.model.CreateRouteRequest;
import software.amazon.awssdk.services.appmesh.model.CreateRouteResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.CreateVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteMeshRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteMeshResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeMeshResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeRouteRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeRouteResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.DescribeVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.model.ForbiddenException;
import software.amazon.awssdk.services.appmesh.model.InternalServerErrorException;
import software.amazon.awssdk.services.appmesh.model.LimitExceededException;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse;
import software.amazon.awssdk.services.appmesh.model.ListMeshesRequest;
import software.amazon.awssdk.services.appmesh.model.ListMeshesResponse;
import software.amazon.awssdk.services.appmesh.model.ListRoutesRequest;
import software.amazon.awssdk.services.appmesh.model.ListRoutesResponse;
import software.amazon.awssdk.services.appmesh.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appmesh.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualServicesResponse;
import software.amazon.awssdk.services.appmesh.model.NotFoundException;
import software.amazon.awssdk.services.appmesh.model.ResourceInUseException;
import software.amazon.awssdk.services.appmesh.model.ServiceUnavailableException;
import software.amazon.awssdk.services.appmesh.model.TagResourceRequest;
import software.amazon.awssdk.services.appmesh.model.TagResourceResponse;
import software.amazon.awssdk.services.appmesh.model.TooManyRequestsException;
import software.amazon.awssdk.services.appmesh.model.TooManyTagsException;
import software.amazon.awssdk.services.appmesh.model.UntagResourceRequest;
import software.amazon.awssdk.services.appmesh.model.UntagResourceResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateGatewayRouteRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateGatewayRouteResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateMeshRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateMeshResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateRouteRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateRouteResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualGatewayResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualNodeResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualRouterResponse;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest;
import software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceResponse;
import software.amazon.awssdk.services.appmesh.transform.CreateGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateMeshRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateVirtualGatewayRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateVirtualNodeRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateVirtualRouterRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.CreateVirtualServiceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteMeshRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteVirtualGatewayRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteVirtualNodeRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteVirtualRouterRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DeleteVirtualServiceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeMeshRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeVirtualGatewayRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeVirtualNodeRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeVirtualRouterRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.DescribeVirtualServiceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListMeshesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListRoutesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListVirtualGatewaysRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListVirtualNodesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListVirtualRoutersRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.ListVirtualServicesRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateMeshRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateRouteRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateVirtualGatewayRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateVirtualNodeRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateVirtualRouterRequestMarshaller;
import software.amazon.awssdk.services.appmesh.transform.UpdateVirtualServiceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAppMeshClient
implements AppMeshClient {
    private static final Logger log = Logger.loggerFor(DefaultAppMeshClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppMeshClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"App_Mesh#2.39.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGatewayRouteResponse createGatewayRoute(CreateGatewayRouteRequest createGatewayRouteRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGatewayRouteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGatewayRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, createGatewayRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGatewayRoute");
            CreateGatewayRouteResponse createGatewayRouteResponse = (CreateGatewayRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGatewayRoute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGatewayRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGatewayRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGatewayRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createGatewayRoute$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMeshResponse createMesh(CreateMeshRequest createMeshRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMeshResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMeshRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, createMeshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMesh");
            CreateMeshResponse createMeshResponse = (CreateMeshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMesh").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMeshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMeshRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMeshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createMesh$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRouteResponse createRoute(CreateRouteRequest createRouteRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRouteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, createRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRoute");
            CreateRouteResponse createRouteResponse = (CreateRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRoute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createRoute$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualGatewayResponse createVirtualGateway(CreateVirtualGatewayRequest createVirtualGatewayRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVirtualGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, createVirtualGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualGateway");
            CreateVirtualGatewayResponse createVirtualGatewayResponse = (CreateVirtualGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVirtualGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createVirtualGateway$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualNodeResponse createVirtualNode(CreateVirtualNodeRequest createVirtualNodeRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVirtualNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, createVirtualNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualNode");
            CreateVirtualNodeResponse createVirtualNodeResponse = (CreateVirtualNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVirtualNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createVirtualNode$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualRouterResponse createVirtualRouter(CreateVirtualRouterRequest createVirtualRouterRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualRouterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVirtualRouterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, createVirtualRouterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualRouter");
            CreateVirtualRouterResponse createVirtualRouterResponse = (CreateVirtualRouterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualRouter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVirtualRouterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualRouterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualRouterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createVirtualRouter$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVirtualServiceResponse createVirtualService(CreateVirtualServiceRequest createVirtualServiceRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVirtualServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createVirtualServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, createVirtualServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVirtualService");
            CreateVirtualServiceResponse createVirtualServiceResponse = (CreateVirtualServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVirtualService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createVirtualServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVirtualServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVirtualServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$createVirtualService$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGatewayRouteResponse deleteGatewayRoute(DeleteGatewayRouteRequest deleteGatewayRouteRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ResourceInUseException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGatewayRouteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGatewayRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, deleteGatewayRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGatewayRoute");
            DeleteGatewayRouteResponse deleteGatewayRouteResponse = (DeleteGatewayRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGatewayRoute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteGatewayRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGatewayRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGatewayRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteGatewayRoute$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMeshResponse deleteMesh(DeleteMeshRequest deleteMeshRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ResourceInUseException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMeshResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMeshRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, deleteMeshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMesh");
            DeleteMeshResponse deleteMeshResponse = (DeleteMeshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMesh").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMeshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMeshRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMeshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteMesh$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRouteResponse deleteRoute(DeleteRouteRequest deleteRouteRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ResourceInUseException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRouteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, deleteRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRoute");
            DeleteRouteResponse deleteRouteResponse = (DeleteRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRoute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteRoute$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualGatewayResponse deleteVirtualGateway(DeleteVirtualGatewayRequest deleteVirtualGatewayRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ResourceInUseException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVirtualGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, deleteVirtualGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualGateway");
            DeleteVirtualGatewayResponse deleteVirtualGatewayResponse = (DeleteVirtualGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVirtualGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteVirtualGateway$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualNodeResponse deleteVirtualNode(DeleteVirtualNodeRequest deleteVirtualNodeRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ResourceInUseException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVirtualNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, deleteVirtualNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualNode");
            DeleteVirtualNodeResponse deleteVirtualNodeResponse = (DeleteVirtualNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVirtualNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteVirtualNode$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualRouterResponse deleteVirtualRouter(DeleteVirtualRouterRequest deleteVirtualRouterRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ResourceInUseException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualRouterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVirtualRouterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, deleteVirtualRouterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualRouter");
            DeleteVirtualRouterResponse deleteVirtualRouterResponse = (DeleteVirtualRouterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualRouter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVirtualRouterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualRouterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualRouterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteVirtualRouter$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualServiceResponse deleteVirtualService(DeleteVirtualServiceRequest deleteVirtualServiceRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ResourceInUseException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVirtualServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVirtualServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, deleteVirtualServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVirtualService");
            DeleteVirtualServiceResponse deleteVirtualServiceResponse = (DeleteVirtualServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVirtualService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteVirtualServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVirtualServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVirtualServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$deleteVirtualService$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGatewayRouteResponse describeGatewayRoute(DescribeGatewayRouteRequest describeGatewayRouteRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGatewayRouteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGatewayRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, describeGatewayRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGatewayRoute");
            DescribeGatewayRouteResponse describeGatewayRouteResponse = (DescribeGatewayRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGatewayRoute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeGatewayRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGatewayRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGatewayRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeGatewayRoute$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMeshResponse describeMesh(DescribeMeshRequest describeMeshRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMeshResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMeshRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, describeMeshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMesh");
            DescribeMeshResponse describeMeshResponse = (DescribeMeshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMesh").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMeshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMeshRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMeshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeMesh$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRouteResponse describeRoute(DescribeRouteRequest describeRouteRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRouteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, describeRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRoute");
            DescribeRouteResponse describeRouteResponse = (DescribeRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRoute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeRoute$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualGatewayResponse describeVirtualGateway(DescribeVirtualGatewayRequest describeVirtualGatewayRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVirtualGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, describeVirtualGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualGateway");
            DescribeVirtualGatewayResponse describeVirtualGatewayResponse = (DescribeVirtualGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVirtualGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeVirtualGateway$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualNodeResponse describeVirtualNode(DescribeVirtualNodeRequest describeVirtualNodeRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVirtualNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, describeVirtualNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualNode");
            DescribeVirtualNodeResponse describeVirtualNodeResponse = (DescribeVirtualNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVirtualNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeVirtualNode$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualRouterResponse describeVirtualRouter(DescribeVirtualRouterRequest describeVirtualRouterRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualRouterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVirtualRouterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, describeVirtualRouterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualRouter");
            DescribeVirtualRouterResponse describeVirtualRouterResponse = (DescribeVirtualRouterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualRouter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVirtualRouterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualRouterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualRouterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeVirtualRouter$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualServiceResponse describeVirtualService(DescribeVirtualServiceRequest describeVirtualServiceRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVirtualServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVirtualServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, describeVirtualServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVirtualService");
            DescribeVirtualServiceResponse describeVirtualServiceResponse = (DescribeVirtualServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVirtualService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeVirtualServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVirtualServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVirtualServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$describeVirtualService$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGatewayRoutesResponse listGatewayRoutes(ListGatewayRoutesRequest listGatewayRoutesRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGatewayRoutesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGatewayRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, listGatewayRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGatewayRoutes");
            ListGatewayRoutesResponse listGatewayRoutesResponse = (ListGatewayRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGatewayRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGatewayRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGatewayRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGatewayRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listGatewayRoutes$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMeshesResponse listMeshes(ListMeshesRequest listMeshesRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMeshesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMeshesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, listMeshesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMeshes");
            ListMeshesResponse listMeshesResponse = (ListMeshesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMeshes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMeshesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMeshesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMeshesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listMeshes$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRoutesResponse listRoutes(ListRoutesRequest listRoutesRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRoutesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, listRoutesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRoutes");
            ListRoutesResponse listRoutesResponse = (ListRoutesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRoutes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRoutesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRoutesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRoutesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listRoutes$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listTagsForResource$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualGatewaysResponse listVirtualGateways(ListVirtualGatewaysRequest listVirtualGatewaysRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualGatewaysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVirtualGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, listVirtualGatewaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualGateways");
            ListVirtualGatewaysResponse listVirtualGatewaysResponse = (ListVirtualGatewaysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualGateways").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVirtualGatewaysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualGatewaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualGatewaysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listVirtualGateways$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualNodesResponse listVirtualNodes(ListVirtualNodesRequest listVirtualNodesRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualNodesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVirtualNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, listVirtualNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualNodes");
            ListVirtualNodesResponse listVirtualNodesResponse = (ListVirtualNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualNodes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVirtualNodesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualNodesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listVirtualNodes$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualRoutersResponse listVirtualRouters(ListVirtualRoutersRequest listVirtualRoutersRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualRoutersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVirtualRoutersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, listVirtualRoutersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualRouters");
            ListVirtualRoutersResponse listVirtualRoutersResponse = (ListVirtualRoutersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualRouters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVirtualRoutersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualRoutersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualRoutersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listVirtualRouters$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualServicesResponse listVirtualServices(ListVirtualServicesRequest listVirtualServicesRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualServicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVirtualServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, listVirtualServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualServices");
            ListVirtualServicesResponse listVirtualServicesResponse = (ListVirtualServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVirtualServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$listVirtualServices$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, BadRequestException, TooManyTagsException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$tagResource$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException, BadRequestException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$untagResource$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGatewayRouteResponse updateGatewayRoute(UpdateGatewayRouteRequest updateGatewayRouteRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGatewayRouteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGatewayRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, updateGatewayRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGatewayRoute");
            UpdateGatewayRouteResponse updateGatewayRouteResponse = (UpdateGatewayRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGatewayRoute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGatewayRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGatewayRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGatewayRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateGatewayRoute$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMeshResponse updateMesh(UpdateMeshRequest updateMeshRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMeshResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMeshRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, updateMeshRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMesh");
            UpdateMeshResponse updateMeshResponse = (UpdateMeshResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMesh").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateMeshRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMeshRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMeshResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateMesh$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRouteResponse updateRoute(UpdateRouteRequest updateRouteRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRouteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, updateRouteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRoute");
            UpdateRouteResponse updateRouteResponse = (UpdateRouteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRoute").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateRouteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRouteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRouteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateRoute$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualGatewayResponse updateVirtualGateway(UpdateVirtualGatewayRequest updateVirtualGatewayRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualGatewayResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVirtualGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, updateVirtualGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualGateway");
            UpdateVirtualGatewayResponse updateVirtualGatewayResponse = (UpdateVirtualGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateVirtualGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateVirtualGateway$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualNodeResponse updateVirtualNode(UpdateVirtualNodeRequest updateVirtualNodeRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVirtualNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, updateVirtualNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualNode");
            UpdateVirtualNodeResponse updateVirtualNodeResponse = (UpdateVirtualNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateVirtualNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateVirtualNode$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualRouterResponse updateVirtualRouter(UpdateVirtualRouterRequest updateVirtualRouterRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualRouterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVirtualRouterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, updateVirtualRouterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualRouter");
            UpdateVirtualRouterResponse updateVirtualRouterResponse = (UpdateVirtualRouterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualRouter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateVirtualRouterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualRouterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualRouterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateVirtualRouter$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVirtualServiceResponse updateVirtualService(UpdateVirtualServiceRequest updateVirtualServiceRequest) throws NotFoundException, BadRequestException, ConflictException, TooManyRequestsException, ForbiddenException, ServiceUnavailableException, InternalServerErrorException, LimitExceededException, AwsServiceException, SdkClientException, AppMeshException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVirtualServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVirtualServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAppMeshClient.resolveMetricPublishers(clientConfiguration, updateVirtualServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"App Mesh");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVirtualService");
            UpdateVirtualServiceResponse updateVirtualServiceResponse = (UpdateVirtualServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVirtualService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateVirtualServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVirtualServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVirtualServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAppMeshClient.lambda$updateVirtualService$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "appmesh";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AppMeshServiceClientConfigurationBuilder serviceConfigBuilder = new AppMeshServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AppMeshException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final AppMeshServiceClientConfiguration serviceClientConfiguration() {
        return new AppMeshServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateVirtualService$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVirtualRouter$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVirtualNode$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVirtualGateway$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRoute$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMesh$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGatewayRoute$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualServices$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualRouters$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualNodes$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualGateways$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRoutes$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMeshes$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGatewayRoutes$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualService$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualRouter$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualNode$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVirtualGateway$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRoute$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMesh$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGatewayRoute$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualService$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualRouter$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualNode$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVirtualGateway$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRoute$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMesh$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGatewayRoute$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualService$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualRouter$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualNode$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVirtualGateway$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRoute$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMesh$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGatewayRoute$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

