/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a target and its relative weight. Traffic is distributed across targets according to their
 * relative weight. For example, a weighted target with a relative weight of 50 receives five times as much traffic as
 * one with a relative weight of 10. The total weight for all targets combined must be less than or equal to 100.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeightedTarget implements SdkPojo, Serializable, ToCopyableBuilder<WeightedTarget.Builder, WeightedTarget> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(WeightedTarget::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> VIRTUAL_NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualNode").getter(getter(WeightedTarget::virtualNode)).setter(setter(Builder::virtualNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNode").build()).build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("weight").getter(getter(WeightedTarget::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD,
            VIRTUAL_NODE_FIELD, WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final String virtualNode;

    private final Integer weight;

    private WeightedTarget(BuilderImpl builder) {
        this.port = builder.port;
        this.virtualNode = builder.virtualNode;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The targeted port of the weighted object.
     * </p>
     * 
     * @return The targeted port of the weighted object.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The virtual node to associate with the weighted target.
     * </p>
     * 
     * @return The virtual node to associate with the weighted target.
     */
    public final String virtualNode() {
        return virtualNode;
    }

    /**
     * <p>
     * The relative weight of the weighted target.
     * </p>
     * 
     * @return The relative weight of the weighted target.
     */
    public final Integer weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNode());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedTarget)) {
            return false;
        }
        WeightedTarget other = (WeightedTarget) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(virtualNode(), other.virtualNode())
                && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WeightedTarget").add("Port", port()).add("VirtualNode", virtualNode()).add("Weight", weight())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "virtualNode":
            return Optional.ofNullable(clazz.cast(virtualNode()));
        case "weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("port", PORT_FIELD);
        map.put("virtualNode", VIRTUAL_NODE_FIELD);
        map.put("weight", WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WeightedTarget, T> g) {
        return obj -> g.apply((WeightedTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeightedTarget> {
        /**
         * <p>
         * The targeted port of the weighted object.
         * </p>
         * 
         * @param port
         *        The targeted port of the weighted object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The virtual node to associate with the weighted target.
         * </p>
         * 
         * @param virtualNode
         *        The virtual node to associate with the weighted target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNode(String virtualNode);

        /**
         * <p>
         * The relative weight of the weighted target.
         * </p>
         * 
         * @param weight
         *        The relative weight of the weighted target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private String virtualNode;

        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(WeightedTarget model) {
            port(model.port);
            virtualNode(model.virtualNode);
            weight(model.weight);
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getVirtualNode() {
            return virtualNode;
        }

        public final void setVirtualNode(String virtualNode) {
            this.virtualNode = virtualNode;
        }

        @Override
        public final Builder virtualNode(String virtualNode) {
            this.virtualNode = virtualNode;
            return this;
        }

        public final Integer getWeight() {
            return weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public WeightedTarget build() {
            return new WeightedTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
