/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a type of connection pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayHttp2ConnectionPool implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayHttp2ConnectionPool.Builder, VirtualGatewayHttp2ConnectionPool> {
    private static final SdkField<Integer> MAX_REQUESTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRequests").getter(getter(VirtualGatewayHttp2ConnectionPool::maxRequests))
            .setter(setter(Builder::maxRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRequests").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxRequests;

    private VirtualGatewayHttp2ConnectionPool(BuilderImpl builder) {
        this.maxRequests = builder.maxRequests;
    }

    /**
     * <p>
     * Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster.
     * </p>
     * 
     * @return Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster.
     */
    public final Integer maxRequests() {
        return maxRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxRequests());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayHttp2ConnectionPool)) {
            return false;
        }
        VirtualGatewayHttp2ConnectionPool other = (VirtualGatewayHttp2ConnectionPool) obj;
        return Objects.equals(maxRequests(), other.maxRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayHttp2ConnectionPool").add("MaxRequests", maxRequests()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxRequests":
            return Optional.ofNullable(clazz.cast(maxRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxRequests", MAX_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayHttp2ConnectionPool, T> g) {
        return obj -> g.apply((VirtualGatewayHttp2ConnectionPool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayHttp2ConnectionPool> {
        /**
         * <p>
         * Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster.
         * </p>
         * 
         * @param maxRequests
         *        Maximum number of inflight requests Envoy can concurrently support across hosts in upstream cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRequests(Integer maxRequests);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayHttp2ConnectionPool model) {
            maxRequests(model.maxRequests);
        }

        public final Integer getMaxRequests() {
            return maxRequests;
        }

        public final void setMaxRequests(Integer maxRequests) {
            this.maxRequests = maxRequests;
        }

        @Override
        public final Builder maxRequests(Integer maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        @Override
        public VirtualGatewayHttp2ConnectionPool build() {
            return new VirtualGatewayHttp2ConnectionPool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
