/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the requirements for a route to match HTTP requests for a virtual router.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpRouteMatch implements SdkPojo, Serializable, ToCopyableBuilder<HttpRouteMatch.Builder, HttpRouteMatch> {
    private static final SdkField<List<HttpRouteHeader>> HEADERS_FIELD = SdkField
            .<List<HttpRouteHeader>> builder(MarshallingType.LIST)
            .memberName("headers")
            .getter(getter(HttpRouteMatch::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpRouteHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpRouteHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("method")
            .getter(getter(HttpRouteMatch::methodAsString)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()).build();

    private static final SdkField<HttpPathMatch> PATH_FIELD = SdkField.<HttpPathMatch> builder(MarshallingType.SDK_POJO)
            .memberName("path").getter(getter(HttpRouteMatch::path)).setter(setter(Builder::path))
            .constructor(HttpPathMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(HttpRouteMatch::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(HttpRouteMatch::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<List<HttpQueryParameter>> QUERY_PARAMETERS_FIELD = SdkField
            .<List<HttpQueryParameter>> builder(MarshallingType.LIST)
            .memberName("queryParameters")
            .getter(getter(HttpRouteMatch::queryParameters))
            .setter(setter(Builder::queryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpQueryParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpQueryParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scheme")
            .getter(getter(HttpRouteMatch::schemeAsString)).setter(setter(Builder::scheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, METHOD_FIELD,
            PATH_FIELD, PORT_FIELD, PREFIX_FIELD, QUERY_PARAMETERS_FIELD, SCHEME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<HttpRouteHeader> headers;

    private final String method;

    private final HttpPathMatch path;

    private final Integer port;

    private final String prefix;

    private final List<HttpQueryParameter> queryParameters;

    private final String scheme;

    private HttpRouteMatch(BuilderImpl builder) {
        this.headers = builder.headers;
        this.method = builder.method;
        this.path = builder.path;
        this.port = builder.port;
        this.prefix = builder.prefix;
        this.queryParameters = builder.queryParameters;
        this.scheme = builder.scheme;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The client request headers to match on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The client request headers to match on.
     */
    public final List<HttpRouteHeader> headers() {
        return headers;
    }

    /**
     * <p>
     * The client request method to match on. Specify only one.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #method} will
     * return {@link HttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #methodAsString}.
     * </p>
     * 
     * @return The client request method to match on. Specify only one.
     * @see HttpMethod
     */
    public final HttpMethod method() {
        return HttpMethod.fromValue(method);
    }

    /**
     * <p>
     * The client request method to match on. Specify only one.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #method} will
     * return {@link HttpMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #methodAsString}.
     * </p>
     * 
     * @return The client request method to match on. Specify only one.
     * @see HttpMethod
     */
    public final String methodAsString() {
        return method;
    }

    /**
     * <p>
     * The client request path to match on.
     * </p>
     * 
     * @return The client request path to match on.
     */
    public final HttpPathMatch path() {
        return path;
    }

    /**
     * <p>
     * The port number to match on.
     * </p>
     * 
     * @return The port number to match on.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by itself
     * matches all requests to the virtual service name. You can also match for path-based routing of requests. For
     * example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests
     * to <code>my-service.local/metrics</code>, your prefix should be <code>/metrics</code>.
     * </p>
     * 
     * @return Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by
     *         itself matches all requests to the virtual service name. You can also match for path-based routing of
     *         requests. For example, if your virtual service name is <code>my-service.local</code> and you want the
     *         route to match requests to <code>my-service.local/metrics</code>, your prefix should be
     *         <code>/metrics</code>.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryParameters() {
        return queryParameters != null && !(queryParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The client request query parameters to match on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryParameters} method.
     * </p>
     * 
     * @return The client request query parameters to match on.
     */
    public final List<HttpQueryParameter> queryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * The client request scheme to match on. Specify only one. Applicable only for HTTP2 routes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheme} will
     * return {@link HttpScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemeAsString}.
     * </p>
     * 
     * @return The client request scheme to match on. Specify only one. Applicable only for HTTP2 routes.
     * @see HttpScheme
     */
    public final HttpScheme scheme() {
        return HttpScheme.fromValue(scheme);
    }

    /**
     * <p>
     * The client request scheme to match on. Specify only one. Applicable only for HTTP2 routes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheme} will
     * return {@link HttpScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #schemeAsString}.
     * </p>
     * 
     * @return The client request scheme to match on. Specify only one. Applicable only for HTTP2 routes.
     * @see HttpScheme
     */
    public final String schemeAsString() {
        return scheme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParameters() ? queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRouteMatch)) {
            return false;
        }
        HttpRouteMatch other = (HttpRouteMatch) obj;
        return hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers())
                && Objects.equals(methodAsString(), other.methodAsString()) && Objects.equals(path(), other.path())
                && Objects.equals(port(), other.port()) && Objects.equals(prefix(), other.prefix())
                && hasQueryParameters() == other.hasQueryParameters()
                && Objects.equals(queryParameters(), other.queryParameters())
                && Objects.equals(schemeAsString(), other.schemeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpRouteMatch").add("Headers", hasHeaders() ? headers() : null).add("Method", methodAsString())
                .add("Path", path()).add("Port", port()).add("Prefix", prefix())
                .add("QueryParameters", hasQueryParameters() ? queryParameters() : null).add("Scheme", schemeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "method":
            return Optional.ofNullable(clazz.cast(methodAsString()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "queryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        case "scheme":
            return Optional.ofNullable(clazz.cast(schemeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("headers", HEADERS_FIELD);
        map.put("method", METHOD_FIELD);
        map.put("path", PATH_FIELD);
        map.put("port", PORT_FIELD);
        map.put("prefix", PREFIX_FIELD);
        map.put("queryParameters", QUERY_PARAMETERS_FIELD);
        map.put("scheme", SCHEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpRouteMatch, T> g) {
        return obj -> g.apply((HttpRouteMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpRouteMatch> {
        /**
         * <p>
         * The client request headers to match on.
         * </p>
         * 
         * @param headers
         *        The client request headers to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<HttpRouteHeader> headers);

        /**
         * <p>
         * The client request headers to match on.
         * </p>
         * 
         * @param headers
         *        The client request headers to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(HttpRouteHeader... headers);

        /**
         * <p>
         * The client request headers to match on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appmesh.model.HttpRouteHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appmesh.model.HttpRouteHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appmesh.model.HttpRouteHeader.Builder#build()} is called immediately
         * and its result is passed to {@link #headers(List<HttpRouteHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appmesh.model.HttpRouteHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<HttpRouteHeader>)
         */
        Builder headers(Consumer<HttpRouteHeader.Builder>... headers);

        /**
         * <p>
         * The client request method to match on. Specify only one.
         * </p>
         * 
         * @param method
         *        The client request method to match on. Specify only one.
         * @see HttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpMethod
         */
        Builder method(String method);

        /**
         * <p>
         * The client request method to match on. Specify only one.
         * </p>
         * 
         * @param method
         *        The client request method to match on. Specify only one.
         * @see HttpMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpMethod
         */
        Builder method(HttpMethod method);

        /**
         * <p>
         * The client request path to match on.
         * </p>
         * 
         * @param path
         *        The client request path to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(HttpPathMatch path);

        /**
         * <p>
         * The client request path to match on.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpPathMatch.Builder} avoiding the need
         * to create one manually via {@link HttpPathMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpPathMatch.Builder#build()} is called immediately and its
         * result is passed to {@link #path(HttpPathMatch)}.
         * 
         * @param path
         *        a consumer that will call methods on {@link HttpPathMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(HttpPathMatch)
         */
        default Builder path(Consumer<HttpPathMatch.Builder> path) {
            return path(HttpPathMatch.builder().applyMutation(path).build());
        }

        /**
         * <p>
         * The port number to match on.
         * </p>
         * 
         * @param port
         *        The port number to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by
         * itself matches all requests to the virtual service name. You can also match for path-based routing of
         * requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route
         * to match requests to <code>my-service.local/metrics</code>, your prefix should be <code>/metrics</code>.
         * </p>
         * 
         * @param prefix
         *        Specifies the path to match requests with. This parameter must always start with <code>/</code>, which
         *        by itself matches all requests to the virtual service name. You can also match for path-based routing
         *        of requests. For example, if your virtual service name is <code>my-service.local</code> and you want
         *        the route to match requests to <code>my-service.local/metrics</code>, your prefix should be
         *        <code>/metrics</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The client request query parameters to match on.
         * </p>
         * 
         * @param queryParameters
         *        The client request query parameters to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(Collection<HttpQueryParameter> queryParameters);

        /**
         * <p>
         * The client request query parameters to match on.
         * </p>
         * 
         * @param queryParameters
         *        The client request query parameters to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(HttpQueryParameter... queryParameters);

        /**
         * <p>
         * The client request query parameters to match on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appmesh.model.HttpQueryParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appmesh.model.HttpQueryParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appmesh.model.HttpQueryParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #queryParameters(List<HttpQueryParameter>)}.
         * 
         * @param queryParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appmesh.model.HttpQueryParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryParameters(java.util.Collection<HttpQueryParameter>)
         */
        Builder queryParameters(Consumer<HttpQueryParameter.Builder>... queryParameters);

        /**
         * <p>
         * The client request scheme to match on. Specify only one. Applicable only for HTTP2 routes.
         * </p>
         * 
         * @param scheme
         *        The client request scheme to match on. Specify only one. Applicable only for HTTP2 routes.
         * @see HttpScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpScheme
         */
        Builder scheme(String scheme);

        /**
         * <p>
         * The client request scheme to match on. Specify only one. Applicable only for HTTP2 routes.
         * </p>
         * 
         * @param scheme
         *        The client request scheme to match on. Specify only one. Applicable only for HTTP2 routes.
         * @see HttpScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpScheme
         */
        Builder scheme(HttpScheme scheme);
    }

    static final class BuilderImpl implements Builder {
        private List<HttpRouteHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private String method;

        private HttpPathMatch path;

        private Integer port;

        private String prefix;

        private List<HttpQueryParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();

        private String scheme;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRouteMatch model) {
            headers(model.headers);
            method(model.method);
            path(model.path);
            port(model.port);
            prefix(model.prefix);
            queryParameters(model.queryParameters);
            scheme(model.scheme);
        }

        public final List<HttpRouteHeader.Builder> getHeaders() {
            List<HttpRouteHeader.Builder> result = HttpRouteHeadersCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<HttpRouteHeader.BuilderImpl> headers) {
            this.headers = HttpRouteHeadersCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<HttpRouteHeader> headers) {
            this.headers = HttpRouteHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(HttpRouteHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<HttpRouteHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> HttpRouteHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMethod() {
            return method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(HttpMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final HttpPathMatch.Builder getPath() {
            return path != null ? path.toBuilder() : null;
        }

        public final void setPath(HttpPathMatch.BuilderImpl path) {
            this.path = path != null ? path.build() : null;
        }

        @Override
        public final Builder path(HttpPathMatch path) {
            this.path = path;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final List<HttpQueryParameter.Builder> getQueryParameters() {
            List<HttpQueryParameter.Builder> result = HttpQueryParametersCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<HttpQueryParameter.BuilderImpl> queryParameters) {
            this.queryParameters = HttpQueryParametersCopier.copyFromBuilder(queryParameters);
        }

        @Override
        public final Builder queryParameters(Collection<HttpQueryParameter> queryParameters) {
            this.queryParameters = HttpQueryParametersCopier.copy(queryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(HttpQueryParameter... queryParameters) {
            queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(Consumer<HttpQueryParameter.Builder>... queryParameters) {
            queryParameters(Stream.of(queryParameters).map(c -> HttpQueryParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getScheme() {
            return scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(HttpScheme scheme) {
            this.scheme(scheme == null ? null : scheme.toString());
            return this;
        }

        @Override
        public HttpRouteMatch build() {
            return new HttpRouteMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
