/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVirtualNodeResponse extends AppMeshResponse implements
        ToCopyableBuilder<DescribeVirtualNodeResponse.Builder, DescribeVirtualNodeResponse> {
    private static final SdkField<VirtualNodeData> VIRTUAL_NODE_FIELD = SdkField
            .<VirtualNodeData> builder(MarshallingType.SDK_POJO)
            .memberName("virtualNode")
            .getter(getter(DescribeVirtualNodeResponse::virtualNode))
            .setter(setter(Builder::virtualNode))
            .constructor(VirtualNodeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNode").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_NODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VirtualNodeData virtualNode;

    private DescribeVirtualNodeResponse(BuilderImpl builder) {
        super(builder);
        this.virtualNode = builder.virtualNode;
    }

    /**
     * <p>
     * The full description of your virtual node.
     * </p>
     * 
     * @return The full description of your virtual node.
     */
    public final VirtualNodeData virtualNode() {
        return virtualNode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualNode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualNodeResponse)) {
            return false;
        }
        DescribeVirtualNodeResponse other = (DescribeVirtualNodeResponse) obj;
        return Objects.equals(virtualNode(), other.virtualNode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVirtualNodeResponse").add("VirtualNode", virtualNode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualNode":
            return Optional.ofNullable(clazz.cast(virtualNode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("virtualNode", VIRTUAL_NODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVirtualNodeResponse, T> g) {
        return obj -> g.apply((DescribeVirtualNodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVirtualNodeResponse> {
        /**
         * <p>
         * The full description of your virtual node.
         * </p>
         * 
         * @param virtualNode
         *        The full description of your virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNode(VirtualNodeData virtualNode);

        /**
         * <p>
         * The full description of your virtual node.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualNodeData.Builder} avoiding the
         * need to create one manually via {@link VirtualNodeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualNodeData.Builder#build()} is called immediately and its
         * result is passed to {@link #virtualNode(VirtualNodeData)}.
         * 
         * @param virtualNode
         *        a consumer that will call methods on {@link VirtualNodeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualNode(VirtualNodeData)
         */
        default Builder virtualNode(Consumer<VirtualNodeData.Builder> virtualNode) {
            return virtualNode(VirtualNodeData.builder().applyMutation(virtualNode).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private VirtualNodeData virtualNode;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualNodeResponse model) {
            super(model);
            virtualNode(model.virtualNode);
        }

        public final VirtualNodeData.Builder getVirtualNode() {
            return virtualNode != null ? virtualNode.toBuilder() : null;
        }

        public final void setVirtualNode(VirtualNodeData.BuilderImpl virtualNode) {
            this.virtualNode = virtualNode != null ? virtualNode.build() : null;
        }

        @Override
        public final Builder virtualNode(VirtualNodeData virtualNode) {
            this.virtualNode = virtualNode;
            return this;
        }

        @Override
        public DescribeVirtualNodeResponse build() {
            return new DescribeVirtualNodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
