/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.services.appmesh.model.TagListCopier;
import software.amazon.awssdk.services.appmesh.model.TagRef;
import software.amazon.awssdk.services.appmesh.model.VirtualNodeSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVirtualNodeRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, CreateVirtualNodeRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateVirtualNodeRequest.getter(CreateVirtualNodeRequest::clientToken)).setter(CreateVirtualNodeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshName").getter(CreateVirtualNodeRequest.getter(CreateVirtualNodeRequest::meshName)).setter(CreateVirtualNodeRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("meshOwner").getter(CreateVirtualNodeRequest.getter(CreateVirtualNodeRequest::meshOwner)).setter(CreateVirtualNodeRequest.setter(Builder::meshOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()}).build();
    private static final SdkField<VirtualNodeSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("spec").getter(CreateVirtualNodeRequest.getter(CreateVirtualNodeRequest::spec)).setter(CreateVirtualNodeRequest.setter(Builder::spec)).constructor(VirtualNodeSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<List<TagRef>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateVirtualNodeRequest.getter(CreateVirtualNodeRequest::tags)).setter(CreateVirtualNodeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VIRTUAL_NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualNodeName").getter(CreateVirtualNodeRequest.getter(CreateVirtualNodeRequest::virtualNodeName)).setter(CreateVirtualNodeRequest.setter(Builder::virtualNodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNodeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, MESH_NAME_FIELD, MESH_OWNER_FIELD, SPEC_FIELD, TAGS_FIELD, VIRTUAL_NODE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVirtualNodeRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String meshName;
    private final String meshOwner;
    private final VirtualNodeSpec spec;
    private final List<TagRef> tags;
    private final String virtualNodeName;

    private CreateVirtualNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.spec = builder.spec;
        this.tags = builder.tags;
        this.virtualNodeName = builder.virtualNodeName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String meshName() {
        return this.meshName;
    }

    public final String meshOwner() {
        return this.meshOwner;
    }

    public final VirtualNodeSpec spec() {
        return this.spec;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagRef> tags() {
        return this.tags;
    }

    public final String virtualNodeName() {
        return this.virtualNodeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNodeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualNodeRequest)) {
            return false;
        }
        CreateVirtualNodeRequest other = (CreateVirtualNodeRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.meshOwner(), other.meshOwner()) && Objects.equals(this.spec(), other.spec()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.virtualNodeName(), other.virtualNodeName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVirtualNodeRequest").add("ClientToken", (Object)this.clientToken()).add("MeshName", (Object)this.meshName()).add("MeshOwner", (Object)this.meshOwner()).add("Spec", (Object)this.spec()).add("Tags", this.hasTags() ? this.tags() : null).add("VirtualNodeName", (Object)this.virtualNodeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "meshOwner": {
                return Optional.ofNullable(clazz.cast(this.meshOwner()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "virtualNodeName": {
                return Optional.ofNullable(clazz.cast(this.virtualNodeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("meshName", MESH_NAME_FIELD);
        map.put("meshOwner", MESH_OWNER_FIELD);
        map.put("spec", SPEC_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("virtualNodeName", VIRTUAL_NODE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVirtualNodeRequest, T> g) {
        return obj -> g.apply((CreateVirtualNodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String meshName;
        private String meshOwner;
        private VirtualNodeSpec spec;
        private List<TagRef> tags = DefaultSdkAutoConstructList.getInstance();
        private String virtualNodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVirtualNodeRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.meshName(model.meshName);
            this.meshOwner(model.meshOwner);
            this.spec(model.spec);
            this.tags(model.tags);
            this.virtualNodeName(model.virtualNodeName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final String getMeshOwner() {
            return this.meshOwner;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final VirtualNodeSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        public final void setSpec(VirtualNodeSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        public final Builder spec(VirtualNodeSpec spec) {
            this.spec = spec;
            return this;
        }

        public final List<TagRef.Builder> getTags() {
            List<TagRef.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagRef.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagRef> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagRef ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagRef.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagRef)((TagRef.Builder)TagRef.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVirtualNodeName() {
            return this.virtualNodeName;
        }

        public final void setVirtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
        }

        @Override
        public final Builder virtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVirtualNodeRequest build() {
            return new CreateVirtualNodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVirtualNodeRequest> {
        public Builder clientToken(String var1);

        public Builder meshName(String var1);

        public Builder meshOwner(String var1);

        public Builder spec(VirtualNodeSpec var1);

        default public Builder spec(Consumer<VirtualNodeSpec.Builder> spec) {
            return this.spec((VirtualNodeSpec)((VirtualNodeSpec.Builder)VirtualNodeSpec.builder().applyMutation(spec)).build());
        }

        public Builder tags(Collection<TagRef> var1);

        public Builder tags(TagRef ... var1);

        public Builder tags(Consumer<TagRef.Builder> ... var1);

        public Builder virtualNodeName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

