/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameMatch;
import software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteHeader;
import software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteHeadersCopier;
import software.amazon.awssdk.services.appmesh.model.HttpMethod;
import software.amazon.awssdk.services.appmesh.model.HttpPathMatch;
import software.amazon.awssdk.services.appmesh.model.HttpQueryParameter;
import software.amazon.awssdk.services.appmesh.model.HttpQueryParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpGatewayRouteMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpGatewayRouteMatch> {
    private static final SdkField<List<HttpGatewayRouteHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("headers").getter(HttpGatewayRouteMatch.getter(HttpGatewayRouteMatch::headers)).setter(HttpGatewayRouteMatch.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpGatewayRouteHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GatewayRouteHostnameMatch> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hostname").getter(HttpGatewayRouteMatch.getter(HttpGatewayRouteMatch::hostname)).setter(HttpGatewayRouteMatch.setter(Builder::hostname)).constructor(GatewayRouteHostnameMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("method").getter(HttpGatewayRouteMatch.getter(HttpGatewayRouteMatch::methodAsString)).setter(HttpGatewayRouteMatch.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final SdkField<HttpPathMatch> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("path").getter(HttpGatewayRouteMatch.getter(HttpGatewayRouteMatch::path)).setter(HttpGatewayRouteMatch.setter(Builder::path)).constructor(HttpPathMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(HttpGatewayRouteMatch.getter(HttpGatewayRouteMatch::port)).setter(HttpGatewayRouteMatch.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(HttpGatewayRouteMatch.getter(HttpGatewayRouteMatch::prefix)).setter(HttpGatewayRouteMatch.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final SdkField<List<HttpQueryParameter>> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queryParameters").getter(HttpGatewayRouteMatch.getter(HttpGatewayRouteMatch::queryParameters)).setter(HttpGatewayRouteMatch.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpQueryParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, HOSTNAME_FIELD, METHOD_FIELD, PATH_FIELD, PORT_FIELD, PREFIX_FIELD, QUERY_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HttpGatewayRouteMatch.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<HttpGatewayRouteHeader> headers;
    private final GatewayRouteHostnameMatch hostname;
    private final String method;
    private final HttpPathMatch path;
    private final Integer port;
    private final String prefix;
    private final List<HttpQueryParameter> queryParameters;

    private HttpGatewayRouteMatch(BuilderImpl builder) {
        this.headers = builder.headers;
        this.hostname = builder.hostname;
        this.method = builder.method;
        this.path = builder.path;
        this.port = builder.port;
        this.prefix = builder.prefix;
        this.queryParameters = builder.queryParameters;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<HttpGatewayRouteHeader> headers() {
        return this.headers;
    }

    public final GatewayRouteHostnameMatch hostname() {
        return this.hostname;
    }

    public final HttpMethod method() {
        return HttpMethod.fromValue(this.method);
    }

    public final String methodAsString() {
        return this.method;
    }

    public final HttpPathMatch path() {
        return this.path;
    }

    public final Integer port() {
        return this.port;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final boolean hasQueryParameters() {
        return this.queryParameters != null && !(this.queryParameters instanceof SdkAutoConstructList);
    }

    public final List<HttpQueryParameter> queryParameters() {
        return this.queryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParameters() ? this.queryParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpGatewayRouteMatch)) {
            return false;
        }
        HttpGatewayRouteMatch other = (HttpGatewayRouteMatch)obj;
        return this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.methodAsString(), other.methodAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.prefix(), other.prefix()) && this.hasQueryParameters() == other.hasQueryParameters() && Objects.equals(this.queryParameters(), other.queryParameters());
    }

    public final String toString() {
        return ToString.builder((String)"HttpGatewayRouteMatch").add("Headers", this.hasHeaders() ? this.headers() : null).add("Hostname", (Object)this.hostname()).add("Method", (Object)this.methodAsString()).add("Path", (Object)this.path()).add("Port", (Object)this.port()).add("Prefix", (Object)this.prefix()).add("QueryParameters", this.hasQueryParameters() ? this.queryParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "method": {
                return Optional.ofNullable(clazz.cast(this.methodAsString()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "queryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("headers", HEADERS_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("method", METHOD_FIELD);
        map.put("path", PATH_FIELD);
        map.put("port", PORT_FIELD);
        map.put("prefix", PREFIX_FIELD);
        map.put("queryParameters", QUERY_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpGatewayRouteMatch, T> g) {
        return obj -> g.apply((HttpGatewayRouteMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<HttpGatewayRouteHeader> headers = DefaultSdkAutoConstructList.getInstance();
        private GatewayRouteHostnameMatch hostname;
        private String method;
        private HttpPathMatch path;
        private Integer port;
        private String prefix;
        private List<HttpQueryParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpGatewayRouteMatch model) {
            this.headers(model.headers);
            this.hostname(model.hostname);
            this.method(model.method);
            this.path(model.path);
            this.port(model.port);
            this.prefix(model.prefix);
            this.queryParameters(model.queryParameters);
        }

        public final List<HttpGatewayRouteHeader.Builder> getHeaders() {
            List<HttpGatewayRouteHeader.Builder> result = HttpGatewayRouteHeadersCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<HttpGatewayRouteHeader.BuilderImpl> headers) {
            this.headers = HttpGatewayRouteHeadersCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<HttpGatewayRouteHeader> headers) {
            this.headers = HttpGatewayRouteHeadersCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(HttpGatewayRouteHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<HttpGatewayRouteHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (HttpGatewayRouteHeader)((HttpGatewayRouteHeader.Builder)HttpGatewayRouteHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GatewayRouteHostnameMatch.Builder getHostname() {
            return this.hostname != null ? this.hostname.toBuilder() : null;
        }

        public final void setHostname(GatewayRouteHostnameMatch.BuilderImpl hostname) {
            this.hostname = hostname != null ? hostname.build() : null;
        }

        @Override
        public final Builder hostname(GatewayRouteHostnameMatch hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(HttpMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final HttpPathMatch.Builder getPath() {
            return this.path != null ? this.path.toBuilder() : null;
        }

        public final void setPath(HttpPathMatch.BuilderImpl path) {
            this.path = path != null ? path.build() : null;
        }

        @Override
        public final Builder path(HttpPathMatch path) {
            this.path = path;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final List<HttpQueryParameter.Builder> getQueryParameters() {
            List<HttpQueryParameter.Builder> result = HttpQueryParametersCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<HttpQueryParameter.BuilderImpl> queryParameters) {
            this.queryParameters = HttpQueryParametersCopier.copyFromBuilder(queryParameters);
        }

        @Override
        public final Builder queryParameters(Collection<HttpQueryParameter> queryParameters) {
            this.queryParameters = HttpQueryParametersCopier.copy(queryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(HttpQueryParameter ... queryParameters) {
            this.queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(Consumer<HttpQueryParameter.Builder> ... queryParameters) {
            this.queryParameters(Stream.of(queryParameters).map(c -> (HttpQueryParameter)((HttpQueryParameter.Builder)HttpQueryParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public HttpGatewayRouteMatch build() {
            return new HttpGatewayRouteMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpGatewayRouteMatch> {
        public Builder headers(Collection<HttpGatewayRouteHeader> var1);

        public Builder headers(HttpGatewayRouteHeader ... var1);

        public Builder headers(Consumer<HttpGatewayRouteHeader.Builder> ... var1);

        public Builder hostname(GatewayRouteHostnameMatch var1);

        default public Builder hostname(Consumer<GatewayRouteHostnameMatch.Builder> hostname) {
            return this.hostname((GatewayRouteHostnameMatch)((GatewayRouteHostnameMatch.Builder)GatewayRouteHostnameMatch.builder().applyMutation(hostname)).build());
        }

        public Builder method(String var1);

        public Builder method(HttpMethod var1);

        public Builder path(HttpPathMatch var1);

        default public Builder path(Consumer<HttpPathMatch.Builder> path) {
            return this.path((HttpPathMatch)((HttpPathMatch.Builder)HttpPathMatch.builder().applyMutation(path)).build());
        }

        public Builder port(Integer var1);

        public Builder prefix(String var1);

        public Builder queryParameters(Collection<HttpQueryParameter> var1);

        public Builder queryParameters(HttpQueryParameter ... var1);

        public Builder queryParameters(Consumer<HttpQueryParameter.Builder> ... var1);
    }
}

