/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.EgressFilter;
import software.amazon.awssdk.services.appmesh.model.MeshServiceDiscovery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeshSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MeshSpec> {
    private static final SdkField<EgressFilter> EGRESS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("egressFilter").getter(MeshSpec.getter(MeshSpec::egressFilter)).setter(MeshSpec.setter(Builder::egressFilter)).constructor(EgressFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressFilter").build()}).build();
    private static final SdkField<MeshServiceDiscovery> SERVICE_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceDiscovery").getter(MeshSpec.getter(MeshSpec::serviceDiscovery)).setter(MeshSpec.setter(Builder::serviceDiscovery)).constructor(MeshServiceDiscovery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDiscovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_FILTER_FIELD, SERVICE_DISCOVERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MeshSpec.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EgressFilter egressFilter;
    private final MeshServiceDiscovery serviceDiscovery;

    private MeshSpec(BuilderImpl builder) {
        this.egressFilter = builder.egressFilter;
        this.serviceDiscovery = builder.serviceDiscovery;
    }

    public final EgressFilter egressFilter() {
        return this.egressFilter;
    }

    public final MeshServiceDiscovery serviceDiscovery() {
        return this.serviceDiscovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.egressFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDiscovery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeshSpec)) {
            return false;
        }
        MeshSpec other = (MeshSpec)obj;
        return Objects.equals(this.egressFilter(), other.egressFilter()) && Objects.equals(this.serviceDiscovery(), other.serviceDiscovery());
    }

    public final String toString() {
        return ToString.builder((String)"MeshSpec").add("EgressFilter", (Object)this.egressFilter()).add("ServiceDiscovery", (Object)this.serviceDiscovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "egressFilter": {
                return Optional.ofNullable(clazz.cast(this.egressFilter()));
            }
            case "serviceDiscovery": {
                return Optional.ofNullable(clazz.cast(this.serviceDiscovery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("egressFilter", EGRESS_FILTER_FIELD);
        map.put("serviceDiscovery", SERVICE_DISCOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MeshSpec, T> g) {
        return obj -> g.apply((MeshSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EgressFilter egressFilter;
        private MeshServiceDiscovery serviceDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(MeshSpec model) {
            this.egressFilter(model.egressFilter);
            this.serviceDiscovery(model.serviceDiscovery);
        }

        public final EgressFilter.Builder getEgressFilter() {
            return this.egressFilter != null ? this.egressFilter.toBuilder() : null;
        }

        public final void setEgressFilter(EgressFilter.BuilderImpl egressFilter) {
            this.egressFilter = egressFilter != null ? egressFilter.build() : null;
        }

        @Override
        public final Builder egressFilter(EgressFilter egressFilter) {
            this.egressFilter = egressFilter;
            return this;
        }

        public final MeshServiceDiscovery.Builder getServiceDiscovery() {
            return this.serviceDiscovery != null ? this.serviceDiscovery.toBuilder() : null;
        }

        public final void setServiceDiscovery(MeshServiceDiscovery.BuilderImpl serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery != null ? serviceDiscovery.build() : null;
        }

        @Override
        public final Builder serviceDiscovery(MeshServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        public MeshSpec build() {
            return new MeshSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MeshSpec> {
        public Builder egressFilter(EgressFilter var1);

        default public Builder egressFilter(Consumer<EgressFilter.Builder> egressFilter) {
            return this.egressFilter((EgressFilter)((EgressFilter.Builder)EgressFilter.builder().applyMutation(egressFilter)).build());
        }

        public Builder serviceDiscovery(MeshServiceDiscovery var1);

        default public Builder serviceDiscovery(Consumer<MeshServiceDiscovery.Builder> serviceDiscovery) {
            return this.serviceDiscovery((MeshServiceDiscovery)((MeshServiceDiscovery.Builder)MeshServiceDiscovery.builder().applyMutation(serviceDiscovery)).build());
        }
    }
}

