/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WeightedTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WeightedTarget> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(WeightedTarget.getter(WeightedTarget::port)).setter(WeightedTarget.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> VIRTUAL_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualNode").getter(WeightedTarget.getter(WeightedTarget::virtualNode)).setter(WeightedTarget.setter(Builder::virtualNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNode").build()}).build();
    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("weight").getter(WeightedTarget.getter(WeightedTarget::weight)).setter(WeightedTarget.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, VIRTUAL_NODE_FIELD, WEIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("port", PORT_FIELD);
            this.put("virtualNode", VIRTUAL_NODE_FIELD);
            this.put("weight", WEIGHT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer port;
    private final String virtualNode;
    private final Integer weight;

    private WeightedTarget(BuilderImpl builder) {
        this.port = builder.port;
        this.virtualNode = builder.virtualNode;
        this.weight = builder.weight;
    }

    public final Integer port() {
        return this.port;
    }

    public final String virtualNode() {
        return this.virtualNode;
    }

    public final Integer weight() {
        return this.weight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedTarget)) {
            return false;
        }
        WeightedTarget other = (WeightedTarget)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.virtualNode(), other.virtualNode()) && Objects.equals(this.weight(), other.weight());
    }

    public final String toString() {
        return ToString.builder((String)"WeightedTarget").add("Port", (Object)this.port()).add("VirtualNode", (Object)this.virtualNode()).add("Weight", (Object)this.weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "virtualNode": {
                return Optional.ofNullable(clazz.cast(this.virtualNode()));
            }
            case "weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WeightedTarget, T> g) {
        return obj -> g.apply((WeightedTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private String virtualNode;
        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(WeightedTarget model) {
            this.port(model.port);
            this.virtualNode(model.virtualNode);
            this.weight(model.weight);
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getVirtualNode() {
            return this.virtualNode;
        }

        public final void setVirtualNode(String virtualNode) {
            this.virtualNode = virtualNode;
        }

        @Override
        public final Builder virtualNode(String virtualNode) {
            this.virtualNode = virtualNode;
            return this;
        }

        public final Integer getWeight() {
            return this.weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public WeightedTarget build() {
            return new WeightedTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WeightedTarget> {
        public Builder port(Integer var1);

        public Builder virtualNode(String var1);

        public Builder weight(Integer var1);
    }
}

