/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpPreference {
    IP_V6_PREFERRED("IPv6_PREFERRED"),
    IP_V4_PREFERRED("IPv4_PREFERRED"),
    IP_V4_ONLY("IPv4_ONLY"),
    IP_V6_ONLY("IPv6_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpPreference> VALUE_MAP;
    private final String value;

    private IpPreference(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpPreference fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpPreference> knownValues() {
        EnumSet<IpPreference> knownValues = EnumSet.allOf(IpPreference.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpPreference.class, IpPreference::toString);
    }
}

