/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameMatch;
import software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteMetadata;
import software.amazon.awssdk.services.appmesh.model.GrpcGatewayRouteMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GrpcGatewayRouteMatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GrpcGatewayRouteMatch> {
    private static final SdkField<GatewayRouteHostnameMatch> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hostname").getter(GrpcGatewayRouteMatch.getter(GrpcGatewayRouteMatch::hostname)).setter(GrpcGatewayRouteMatch.setter(Builder::hostname)).constructor(GatewayRouteHostnameMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<List<GrpcGatewayRouteMetadata>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadata").getter(GrpcGatewayRouteMatch.getter(GrpcGatewayRouteMatch::metadata)).setter(GrpcGatewayRouteMatch.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GrpcGatewayRouteMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(GrpcGatewayRouteMatch.getter(GrpcGatewayRouteMatch::port)).setter(GrpcGatewayRouteMatch.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(GrpcGatewayRouteMatch.getter(GrpcGatewayRouteMatch::serviceName)).setter(GrpcGatewayRouteMatch.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD, METADATA_FIELD, PORT_FIELD, SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("hostname", HOSTNAME_FIELD);
            this.put("metadata", METADATA_FIELD);
            this.put("port", PORT_FIELD);
            this.put("serviceName", SERVICE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final GatewayRouteHostnameMatch hostname;
    private final List<GrpcGatewayRouteMetadata> metadata;
    private final Integer port;
    private final String serviceName;

    private GrpcGatewayRouteMatch(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.metadata = builder.metadata;
        this.port = builder.port;
        this.serviceName = builder.serviceName;
    }

    public final GatewayRouteHostnameMatch hostname() {
        return this.hostname;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructList);
    }

    public final List<GrpcGatewayRouteMetadata> metadata() {
        return this.metadata;
    }

    public final Integer port() {
        return this.port;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcGatewayRouteMatch)) {
            return false;
        }
        GrpcGatewayRouteMatch other = (GrpcGatewayRouteMatch)obj;
        return Objects.equals(this.hostname(), other.hostname()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public final String toString() {
        return ToString.builder((String)"GrpcGatewayRouteMatch").add("Hostname", (Object)this.hostname()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("Port", (Object)this.port()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GrpcGatewayRouteMatch, T> g) {
        return obj -> g.apply((GrpcGatewayRouteMatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GatewayRouteHostnameMatch hostname;
        private List<GrpcGatewayRouteMetadata> metadata = DefaultSdkAutoConstructList.getInstance();
        private Integer port;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcGatewayRouteMatch model) {
            this.hostname(model.hostname);
            this.metadata(model.metadata);
            this.port(model.port);
            this.serviceName(model.serviceName);
        }

        public final GatewayRouteHostnameMatch.Builder getHostname() {
            return this.hostname != null ? this.hostname.toBuilder() : null;
        }

        public final void setHostname(GatewayRouteHostnameMatch.BuilderImpl hostname) {
            this.hostname = hostname != null ? hostname.build() : null;
        }

        @Override
        public final Builder hostname(GatewayRouteHostnameMatch hostname) {
            this.hostname = hostname;
            return this;
        }

        public final List<GrpcGatewayRouteMetadata.Builder> getMetadata() {
            List<GrpcGatewayRouteMetadata.Builder> result = GrpcGatewayRouteMetadataListCopier.copyToBuilder(this.metadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadata(Collection<GrpcGatewayRouteMetadata.BuilderImpl> metadata) {
            this.metadata = GrpcGatewayRouteMetadataListCopier.copyFromBuilder(metadata);
        }

        @Override
        public final Builder metadata(Collection<GrpcGatewayRouteMetadata> metadata) {
            this.metadata = GrpcGatewayRouteMetadataListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(GrpcGatewayRouteMetadata ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(Consumer<GrpcGatewayRouteMetadata.Builder> ... metadata) {
            this.metadata(Stream.of(metadata).map(c -> (GrpcGatewayRouteMetadata)((GrpcGatewayRouteMetadata.Builder)GrpcGatewayRouteMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public GrpcGatewayRouteMatch build() {
            return new GrpcGatewayRouteMatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GrpcGatewayRouteMatch> {
        public Builder hostname(GatewayRouteHostnameMatch var1);

        default public Builder hostname(Consumer<GatewayRouteHostnameMatch.Builder> hostname) {
            return this.hostname((GatewayRouteHostnameMatch)((GatewayRouteHostnameMatch.Builder)GatewayRouteHostnameMatch.builder().applyMutation(hostname)).build());
        }

        public Builder metadata(Collection<GrpcGatewayRouteMetadata> var1);

        public Builder metadata(GrpcGatewayRouteMetadata ... var1);

        public Builder metadata(Consumer<GrpcGatewayRouteMetadata.Builder> ... var1);

        public Builder port(Integer var1);

        public Builder serviceName(String var1);
    }
}

