/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DurationUnit {
    S("s"),
    MS("ms"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DurationUnit> VALUE_MAP;
    private final String value;

    private DurationUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DurationUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DurationUnit> knownValues() {
        EnumSet<DurationUnit> knownValues = EnumSet.allOf(DurationUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DurationUnit.class, DurationUnit::toString);
    }
}

