/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the metadata of the gateway route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcGatewayRouteMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<GrpcGatewayRouteMetadata.Builder, GrpcGatewayRouteMetadata> {
    private static final SdkField<Boolean> INVERT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("invert").getter(getter(GrpcGatewayRouteMetadata::invert)).setter(setter(Builder::invert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invert").build()).build();

    private static final SdkField<GrpcMetadataMatchMethod> MATCH_FIELD = SdkField
            .<GrpcMetadataMatchMethod> builder(MarshallingType.SDK_POJO).memberName("match")
            .getter(getter(GrpcGatewayRouteMetadata::match)).setter(setter(Builder::match))
            .constructor(GrpcMetadataMatchMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GrpcGatewayRouteMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVERT_FIELD, MATCH_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean invert;

    private final GrpcMetadataMatchMethod match;

    private final String name;

    private GrpcGatewayRouteMetadata(BuilderImpl builder) {
        this.invert = builder.invert;
        this.match = builder.match;
        this.name = builder.name;
    }

    /**
     * <p>
     * Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.
     * </p>
     * 
     * @return Specify <code>True</code> to match anything except the match criteria. The default value is
     *         <code>False</code>.
     */
    public final Boolean invert() {
        return invert;
    }

    /**
     * <p>
     * The criteria for determining a metadata match.
     * </p>
     * 
     * @return The criteria for determining a metadata match.
     */
    public final GrpcMetadataMatchMethod match() {
        return match;
    }

    /**
     * <p>
     * A name for the gateway route metadata.
     * </p>
     * 
     * @return A name for the gateway route metadata.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invert());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcGatewayRouteMetadata)) {
            return false;
        }
        GrpcGatewayRouteMetadata other = (GrpcGatewayRouteMetadata) obj;
        return Objects.equals(invert(), other.invert()) && Objects.equals(match(), other.match())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcGatewayRouteMetadata").add("Invert", invert()).add("Match", match()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invert":
            return Optional.ofNullable(clazz.cast(invert()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcGatewayRouteMetadata, T> g) {
        return obj -> g.apply((GrpcGatewayRouteMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcGatewayRouteMetadata> {
        /**
         * <p>
         * Specify <code>True</code> to match anything except the match criteria. The default value is
         * <code>False</code>.
         * </p>
         * 
         * @param invert
         *        Specify <code>True</code> to match anything except the match criteria. The default value is
         *        <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invert(Boolean invert);

        /**
         * <p>
         * The criteria for determining a metadata match.
         * </p>
         * 
         * @param match
         *        The criteria for determining a metadata match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(GrpcMetadataMatchMethod match);

        /**
         * <p>
         * The criteria for determining a metadata match.
         * </p>
         * This is a convenience method that creates an instance of the {@link GrpcMetadataMatchMethod.Builder} avoiding
         * the need to create one manually via {@link GrpcMetadataMatchMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GrpcMetadataMatchMethod.Builder#build()} is called immediately
         * and its result is passed to {@link #match(GrpcMetadataMatchMethod)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link GrpcMetadataMatchMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(GrpcMetadataMatchMethod)
         */
        default Builder match(Consumer<GrpcMetadataMatchMethod.Builder> match) {
            return match(GrpcMetadataMatchMethod.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * A name for the gateway route metadata.
         * </p>
         * 
         * @param name
         *        A name for the gateway route metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private Boolean invert;

        private GrpcMetadataMatchMethod match;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcGatewayRouteMetadata model) {
            invert(model.invert);
            match(model.match);
            name(model.name);
        }

        public final Boolean getInvert() {
            return invert;
        }

        public final void setInvert(Boolean invert) {
            this.invert = invert;
        }

        @Override
        public final Builder invert(Boolean invert) {
            this.invert = invert;
            return this;
        }

        public final GrpcMetadataMatchMethod.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(GrpcMetadataMatchMethod.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(GrpcMetadataMatchMethod match) {
            this.match = match;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public GrpcGatewayRouteMetadata build() {
            return new GrpcGatewayRouteMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
