/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.JsonFormatCopier;
import software.amazon.awssdk.services.appmesh.model.JsonFormatRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingFormat> {
    private static final SdkField<List<JsonFormatRef>> JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("json").getter(LoggingFormat.getter(LoggingFormat::json)).setter(LoggingFormat.setter(Builder::json)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("json").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JsonFormatRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(LoggingFormat.getter(LoggingFormat::text)).setter(LoggingFormat.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_FIELD, TEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<JsonFormatRef> json;
    private final String text;
    private final Type type;

    private LoggingFormat(BuilderImpl builder) {
        this.json = builder.json;
        this.text = builder.text;
        this.type = builder.type;
    }

    public final boolean hasJson() {
        return this.json != null && !(this.json instanceof SdkAutoConstructList);
    }

    public final List<JsonFormatRef> json() {
        return this.json;
    }

    public final String text() {
        return this.text;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJson() ? this.json() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingFormat)) {
            return false;
        }
        LoggingFormat other = (LoggingFormat)obj;
        return this.hasJson() == other.hasJson() && Objects.equals(this.json(), other.json()) && Objects.equals(this.text(), other.text());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingFormat").add("Json", this.hasJson() ? this.json() : null).add("Text", (Object)this.text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "json": {
                return Optional.ofNullable(clazz.cast(this.json()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
        }
        return Optional.empty();
    }

    public static LoggingFormat fromJson(List<JsonFormatRef> json) {
        return (LoggingFormat)LoggingFormat.builder().json(json).build();
    }

    public static LoggingFormat fromText(String text) {
        return (LoggingFormat)LoggingFormat.builder().text(text).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingFormat, T> g) {
        return obj -> g.apply((LoggingFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        JSON,
        TEXT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<JsonFormatRef> json = DefaultSdkAutoConstructList.getInstance();
        private String text;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingFormat model) {
            this.json(model.json);
            this.text(model.text);
        }

        public final List<JsonFormatRef.Builder> getJson() {
            List<JsonFormatRef.Builder> result = JsonFormatCopier.copyToBuilder(this.json);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJson(Collection<JsonFormatRef.BuilderImpl> json) {
            List<JsonFormatRef> oldValue = this.json;
            this.json = JsonFormatCopier.copyFromBuilder(json);
            this.handleUnionValueChange(Type.JSON, oldValue, this.json);
        }

        @Override
        public final Builder json(Collection<JsonFormatRef> json) {
            List<JsonFormatRef> oldValue = this.json;
            this.json = JsonFormatCopier.copy(json);
            this.handleUnionValueChange(Type.JSON, oldValue, this.json);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder json(JsonFormatRef ... json) {
            this.json(Arrays.asList(json));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder json(Consumer<JsonFormatRef.Builder> ... json) {
            this.json(Stream.of(json).map(c -> (JsonFormatRef)((JsonFormatRef.Builder)JsonFormatRef.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public LoggingFormat build() {
            return new LoggingFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingFormat> {
        public Builder json(Collection<JsonFormatRef> var1);

        public Builder json(JsonFormatRef ... var1);

        public Builder json(Consumer<JsonFormatRef.Builder> ... var1);

        public Builder text(String var1);
    }
}

