/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsAcmCertificate;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsFileCertificate;
import software.amazon.awssdk.services.appmesh.model.ListenerTlsSdsCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListenerTlsCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListenerTlsCertificate> {
    private static final SdkField<ListenerTlsAcmCertificate> ACM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acm").getter(ListenerTlsCertificate.getter(ListenerTlsCertificate::acm)).setter(ListenerTlsCertificate.setter(Builder::acm)).constructor(ListenerTlsAcmCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acm").build()}).build();
    private static final SdkField<ListenerTlsFileCertificate> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(ListenerTlsCertificate.getter(ListenerTlsCertificate::file)).setter(ListenerTlsCertificate.setter(Builder::file)).constructor(ListenerTlsFileCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final SdkField<ListenerTlsSdsCertificate> SDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sds").getter(ListenerTlsCertificate.getter(ListenerTlsCertificate::sds)).setter(ListenerTlsCertificate.setter(Builder::sds)).constructor(ListenerTlsSdsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_FIELD, FILE_FIELD, SDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ListenerTlsAcmCertificate acm;
    private final ListenerTlsFileCertificate file;
    private final ListenerTlsSdsCertificate sds;
    private final Type type;

    private ListenerTlsCertificate(BuilderImpl builder) {
        this.acm = builder.acm;
        this.file = builder.file;
        this.sds = builder.sds;
        this.type = builder.type;
    }

    public final ListenerTlsAcmCertificate acm() {
        return this.acm;
    }

    public final ListenerTlsFileCertificate file() {
        return this.file;
    }

    public final ListenerTlsSdsCertificate sds() {
        return this.sds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acm());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.sds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerTlsCertificate)) {
            return false;
        }
        ListenerTlsCertificate other = (ListenerTlsCertificate)obj;
        return Objects.equals(this.acm(), other.acm()) && Objects.equals(this.file(), other.file()) && Objects.equals(this.sds(), other.sds());
    }

    public final String toString() {
        return ToString.builder((String)"ListenerTlsCertificate").add("Acm", (Object)this.acm()).add("File", (Object)this.file()).add("Sds", (Object)this.sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acm": {
                return Optional.ofNullable(clazz.cast(this.acm()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "sds": {
                return Optional.ofNullable(clazz.cast(this.sds()));
            }
        }
        return Optional.empty();
    }

    public static ListenerTlsCertificate fromAcm(ListenerTlsAcmCertificate acm) {
        return (ListenerTlsCertificate)ListenerTlsCertificate.builder().acm(acm).build();
    }

    public static ListenerTlsCertificate fromAcm(Consumer<ListenerTlsAcmCertificate.Builder> acm) {
        ListenerTlsAcmCertificate.Builder builder = ListenerTlsAcmCertificate.builder();
        acm.accept(builder);
        return ListenerTlsCertificate.fromAcm((ListenerTlsAcmCertificate)builder.build());
    }

    public static ListenerTlsCertificate fromFile(ListenerTlsFileCertificate file) {
        return (ListenerTlsCertificate)ListenerTlsCertificate.builder().file(file).build();
    }

    public static ListenerTlsCertificate fromFile(Consumer<ListenerTlsFileCertificate.Builder> file) {
        ListenerTlsFileCertificate.Builder builder = ListenerTlsFileCertificate.builder();
        file.accept(builder);
        return ListenerTlsCertificate.fromFile((ListenerTlsFileCertificate)builder.build());
    }

    public static ListenerTlsCertificate fromSds(ListenerTlsSdsCertificate sds) {
        return (ListenerTlsCertificate)ListenerTlsCertificate.builder().sds(sds).build();
    }

    public static ListenerTlsCertificate fromSds(Consumer<ListenerTlsSdsCertificate.Builder> sds) {
        ListenerTlsSdsCertificate.Builder builder = ListenerTlsSdsCertificate.builder();
        sds.accept(builder);
        return ListenerTlsCertificate.fromSds((ListenerTlsSdsCertificate)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListenerTlsCertificate, T> g) {
        return obj -> g.apply((ListenerTlsCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ACM,
        FILE,
        SDS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ListenerTlsAcmCertificate acm;
        private ListenerTlsFileCertificate file;
        private ListenerTlsSdsCertificate sds;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerTlsCertificate model) {
            this.acm(model.acm);
            this.file(model.file);
            this.sds(model.sds);
        }

        public final ListenerTlsAcmCertificate.Builder getAcm() {
            return this.acm != null ? this.acm.toBuilder() : null;
        }

        public final void setAcm(ListenerTlsAcmCertificate.BuilderImpl acm) {
            ListenerTlsAcmCertificate oldValue = this.acm;
            this.acm = acm != null ? acm.build() : null;
            this.handleUnionValueChange(Type.ACM, oldValue, this.acm);
        }

        @Override
        public final Builder acm(ListenerTlsAcmCertificate acm) {
            ListenerTlsAcmCertificate oldValue = this.acm;
            this.acm = acm;
            this.handleUnionValueChange(Type.ACM, oldValue, this.acm);
            return this;
        }

        public final ListenerTlsFileCertificate.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(ListenerTlsFileCertificate.BuilderImpl file) {
            ListenerTlsFileCertificate oldValue = this.file;
            this.file = file != null ? file.build() : null;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(ListenerTlsFileCertificate file) {
            ListenerTlsFileCertificate oldValue = this.file;
            this.file = file;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final ListenerTlsSdsCertificate.Builder getSds() {
            return this.sds != null ? this.sds.toBuilder() : null;
        }

        public final void setSds(ListenerTlsSdsCertificate.BuilderImpl sds) {
            ListenerTlsSdsCertificate oldValue = this.sds;
            this.sds = sds != null ? sds.build() : null;
            this.handleUnionValueChange(Type.SDS, oldValue, this.sds);
        }

        @Override
        public final Builder sds(ListenerTlsSdsCertificate sds) {
            ListenerTlsSdsCertificate oldValue = this.sds;
            this.sds = sds;
            this.handleUnionValueChange(Type.SDS, oldValue, this.sds);
            return this;
        }

        public ListenerTlsCertificate build() {
            return new ListenerTlsCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListenerTlsCertificate> {
        public Builder acm(ListenerTlsAcmCertificate var1);

        default public Builder acm(Consumer<ListenerTlsAcmCertificate.Builder> acm) {
            return this.acm((ListenerTlsAcmCertificate)((ListenerTlsAcmCertificate.Builder)ListenerTlsAcmCertificate.builder().applyMutation(acm)).build());
        }

        public Builder file(ListenerTlsFileCertificate var1);

        default public Builder file(Consumer<ListenerTlsFileCertificate.Builder> file) {
            return this.file((ListenerTlsFileCertificate)((ListenerTlsFileCertificate.Builder)ListenerTlsFileCertificate.builder().applyMutation(file)).build());
        }

        public Builder sds(ListenerTlsSdsCertificate var1);

        default public Builder sds(Consumer<ListenerTlsSdsCertificate.Builder> sds) {
            return this.sds((ListenerTlsSdsCertificate)((ListenerTlsSdsCertificate.Builder)ListenerTlsSdsCertificate.builder().applyMutation(sds)).build());
        }
    }
}

