/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.AwsCloudMapInstanceAttribute;
import software.amazon.awssdk.services.appmesh.model.AwsCloudMapInstanceAttributesCopier;
import software.amazon.awssdk.services.appmesh.model.IpPreference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudMapServiceDiscovery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudMapServiceDiscovery> {
    private static final SdkField<List<AwsCloudMapInstanceAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(AwsCloudMapServiceDiscovery.getter(AwsCloudMapServiceDiscovery::attributes)).setter(AwsCloudMapServiceDiscovery.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCloudMapInstanceAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipPreference").getter(AwsCloudMapServiceDiscovery.getter(AwsCloudMapServiceDiscovery::ipPreferenceAsString)).setter(AwsCloudMapServiceDiscovery.setter(Builder::ipPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipPreference").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(AwsCloudMapServiceDiscovery.getter(AwsCloudMapServiceDiscovery::namespaceName)).setter(AwsCloudMapServiceDiscovery.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(AwsCloudMapServiceDiscovery.getter(AwsCloudMapServiceDiscovery::serviceName)).setter(AwsCloudMapServiceDiscovery.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, IP_PREFERENCE_FIELD, NAMESPACE_NAME_FIELD, SERVICE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AwsCloudMapInstanceAttribute> attributes;
    private final String ipPreference;
    private final String namespaceName;
    private final String serviceName;

    private AwsCloudMapServiceDiscovery(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.ipPreference = builder.ipPreference;
        this.namespaceName = builder.namespaceName;
        this.serviceName = builder.serviceName;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<AwsCloudMapInstanceAttribute> attributes() {
        return this.attributes;
    }

    public final IpPreference ipPreference() {
        return IpPreference.fromValue(this.ipPreference);
    }

    public final String ipPreferenceAsString() {
        return this.ipPreference;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudMapServiceDiscovery)) {
            return false;
        }
        AwsCloudMapServiceDiscovery other = (AwsCloudMapServiceDiscovery)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.ipPreferenceAsString(), other.ipPreferenceAsString()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudMapServiceDiscovery").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("IpPreference", (Object)this.ipPreferenceAsString()).add("NamespaceName", (Object)this.namespaceName()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ipPreference": {
                return Optional.ofNullable(clazz.cast(this.ipPreferenceAsString()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudMapServiceDiscovery, T> g) {
        return obj -> g.apply((AwsCloudMapServiceDiscovery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AwsCloudMapInstanceAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private String ipPreference;
        private String namespaceName;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudMapServiceDiscovery model) {
            this.attributes(model.attributes);
            this.ipPreference(model.ipPreference);
            this.namespaceName(model.namespaceName);
            this.serviceName(model.serviceName);
        }

        public final List<AwsCloudMapInstanceAttribute.Builder> getAttributes() {
            List<AwsCloudMapInstanceAttribute.Builder> result = AwsCloudMapInstanceAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<AwsCloudMapInstanceAttribute.BuilderImpl> attributes) {
            this.attributes = AwsCloudMapInstanceAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<AwsCloudMapInstanceAttribute> attributes) {
            this.attributes = AwsCloudMapInstanceAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AwsCloudMapInstanceAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AwsCloudMapInstanceAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (AwsCloudMapInstanceAttribute)((AwsCloudMapInstanceAttribute.Builder)AwsCloudMapInstanceAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpPreference() {
            return this.ipPreference;
        }

        public final void setIpPreference(String ipPreference) {
            this.ipPreference = ipPreference;
        }

        @Override
        public final Builder ipPreference(String ipPreference) {
            this.ipPreference = ipPreference;
            return this;
        }

        @Override
        public final Builder ipPreference(IpPreference ipPreference) {
            this.ipPreference(ipPreference == null ? null : ipPreference.toString());
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public AwsCloudMapServiceDiscovery build() {
            return new AwsCloudMapServiceDiscovery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudMapServiceDiscovery> {
        public Builder attributes(Collection<AwsCloudMapInstanceAttribute> var1);

        public Builder attributes(AwsCloudMapInstanceAttribute ... var1);

        public Builder attributes(Consumer<AwsCloudMapInstanceAttribute.Builder> ... var1);

        public Builder ipPreference(String var1);

        public Builder ipPreference(IpPreference var1);

        public Builder namespaceName(String var1);

        public Builder serviceName(String var1);
    }
}

