/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.GrpcRoute;
import software.amazon.awssdk.services.appmesh.model.HttpRoute;
import software.amazon.awssdk.services.appmesh.model.TcpRoute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteSpec> {
    private static final SdkField<GrpcRoute> GRPC_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("grpcRoute").getter(RouteSpec.getter(RouteSpec::grpcRoute)).setter(RouteSpec.setter(Builder::grpcRoute)).constructor(GrpcRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grpcRoute").build()}).build();
    private static final SdkField<HttpRoute> HTTP2_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("http2Route").getter(RouteSpec.getter(RouteSpec::http2Route)).setter(RouteSpec.setter(Builder::http2Route)).constructor(HttpRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http2Route").build()}).build();
    private static final SdkField<HttpRoute> HTTP_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("httpRoute").getter(RouteSpec.getter(RouteSpec::httpRoute)).setter(RouteSpec.setter(Builder::httpRoute)).constructor(HttpRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRoute").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(RouteSpec.getter(RouteSpec::priority)).setter(RouteSpec.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<TcpRoute> TCP_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tcpRoute").getter(RouteSpec.getter(RouteSpec::tcpRoute)).setter(RouteSpec.setter(Builder::tcpRoute)).constructor(TcpRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcpRoute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRPC_ROUTE_FIELD, HTTP2_ROUTE_FIELD, HTTP_ROUTE_FIELD, PRIORITY_FIELD, TCP_ROUTE_FIELD));
    private static final long serialVersionUID = 1L;
    private final GrpcRoute grpcRoute;
    private final HttpRoute http2Route;
    private final HttpRoute httpRoute;
    private final Integer priority;
    private final TcpRoute tcpRoute;

    private RouteSpec(BuilderImpl builder) {
        this.grpcRoute = builder.grpcRoute;
        this.http2Route = builder.http2Route;
        this.httpRoute = builder.httpRoute;
        this.priority = builder.priority;
        this.tcpRoute = builder.tcpRoute;
    }

    public final GrpcRoute grpcRoute() {
        return this.grpcRoute;
    }

    public final HttpRoute http2Route() {
        return this.http2Route;
    }

    public final HttpRoute httpRoute() {
        return this.httpRoute;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final TcpRoute tcpRoute() {
        return this.tcpRoute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grpcRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.http2Route());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.tcpRoute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSpec)) {
            return false;
        }
        RouteSpec other = (RouteSpec)obj;
        return Objects.equals(this.grpcRoute(), other.grpcRoute()) && Objects.equals(this.http2Route(), other.http2Route()) && Objects.equals(this.httpRoute(), other.httpRoute()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.tcpRoute(), other.tcpRoute());
    }

    public final String toString() {
        return ToString.builder((String)"RouteSpec").add("GrpcRoute", (Object)this.grpcRoute()).add("Http2Route", (Object)this.http2Route()).add("HttpRoute", (Object)this.httpRoute()).add("Priority", (Object)this.priority()).add("TcpRoute", (Object)this.tcpRoute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grpcRoute": {
                return Optional.ofNullable(clazz.cast(this.grpcRoute()));
            }
            case "http2Route": {
                return Optional.ofNullable(clazz.cast(this.http2Route()));
            }
            case "httpRoute": {
                return Optional.ofNullable(clazz.cast(this.httpRoute()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "tcpRoute": {
                return Optional.ofNullable(clazz.cast(this.tcpRoute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteSpec, T> g) {
        return obj -> g.apply((RouteSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GrpcRoute grpcRoute;
        private HttpRoute http2Route;
        private HttpRoute httpRoute;
        private Integer priority;
        private TcpRoute tcpRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSpec model) {
            this.grpcRoute(model.grpcRoute);
            this.http2Route(model.http2Route);
            this.httpRoute(model.httpRoute);
            this.priority(model.priority);
            this.tcpRoute(model.tcpRoute);
        }

        public final GrpcRoute.Builder getGrpcRoute() {
            return this.grpcRoute != null ? this.grpcRoute.toBuilder() : null;
        }

        public final void setGrpcRoute(GrpcRoute.BuilderImpl grpcRoute) {
            this.grpcRoute = grpcRoute != null ? grpcRoute.build() : null;
        }

        @Override
        @Transient
        public final Builder grpcRoute(GrpcRoute grpcRoute) {
            this.grpcRoute = grpcRoute;
            return this;
        }

        public final HttpRoute.Builder getHttp2Route() {
            return this.http2Route != null ? this.http2Route.toBuilder() : null;
        }

        public final void setHttp2Route(HttpRoute.BuilderImpl http2Route) {
            this.http2Route = http2Route != null ? http2Route.build() : null;
        }

        @Override
        @Transient
        public final Builder http2Route(HttpRoute http2Route) {
            this.http2Route = http2Route;
            return this;
        }

        public final HttpRoute.Builder getHttpRoute() {
            return this.httpRoute != null ? this.httpRoute.toBuilder() : null;
        }

        public final void setHttpRoute(HttpRoute.BuilderImpl httpRoute) {
            this.httpRoute = httpRoute != null ? httpRoute.build() : null;
        }

        @Override
        @Transient
        public final Builder httpRoute(HttpRoute httpRoute) {
            this.httpRoute = httpRoute;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final TcpRoute.Builder getTcpRoute() {
            return this.tcpRoute != null ? this.tcpRoute.toBuilder() : null;
        }

        public final void setTcpRoute(TcpRoute.BuilderImpl tcpRoute) {
            this.tcpRoute = tcpRoute != null ? tcpRoute.build() : null;
        }

        @Override
        @Transient
        public final Builder tcpRoute(TcpRoute tcpRoute) {
            this.tcpRoute = tcpRoute;
            return this;
        }

        public RouteSpec build() {
            return new RouteSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteSpec> {
        public Builder grpcRoute(GrpcRoute var1);

        default public Builder grpcRoute(Consumer<GrpcRoute.Builder> grpcRoute) {
            return this.grpcRoute((GrpcRoute)((GrpcRoute.Builder)GrpcRoute.builder().applyMutation(grpcRoute)).build());
        }

        public Builder http2Route(HttpRoute var1);

        default public Builder http2Route(Consumer<HttpRoute.Builder> http2Route) {
            return this.http2Route((HttpRoute)((HttpRoute.Builder)HttpRoute.builder().applyMutation(http2Route)).build());
        }

        public Builder httpRoute(HttpRoute var1);

        default public Builder httpRoute(Consumer<HttpRoute.Builder> httpRoute) {
            return this.httpRoute((HttpRoute)((HttpRoute.Builder)HttpRoute.builder().applyMutation(httpRoute)).build());
        }

        public Builder priority(Integer var1);

        public Builder tcpRoute(TcpRoute var1);

        default public Builder tcpRoute(Consumer<TcpRoute.Builder> tcpRoute) {
            return this.tcpRoute((TcpRoute)((TcpRoute.Builder)TcpRoute.builder().applyMutation(tcpRoute)).build());
        }
    }
}

