/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.DnsResponseType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsServiceDiscovery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsServiceDiscovery> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(DnsServiceDiscovery.getter(DnsServiceDiscovery::hostname)).setter(DnsServiceDiscovery.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> RESPONSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseType").getter(DnsServiceDiscovery.getter(DnsServiceDiscovery::responseTypeAsString)).setter(DnsServiceDiscovery.setter(Builder::responseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD, RESPONSE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hostname;
    private final String responseType;

    private DnsServiceDiscovery(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.responseType = builder.responseType;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final DnsResponseType responseType() {
        return DnsResponseType.fromValue(this.responseType);
    }

    public final String responseTypeAsString() {
        return this.responseType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsServiceDiscovery)) {
            return false;
        }
        DnsServiceDiscovery other = (DnsServiceDiscovery)obj;
        return Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.responseTypeAsString(), other.responseTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DnsServiceDiscovery").add("Hostname", (Object)this.hostname()).add("ResponseType", (Object)this.responseTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "responseType": {
                return Optional.ofNullable(clazz.cast(this.responseTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsServiceDiscovery, T> g) {
        return obj -> g.apply((DnsServiceDiscovery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostname;
        private String responseType;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsServiceDiscovery model) {
            this.hostname(model.hostname);
            this.responseType(model.responseType);
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getResponseType() {
            return this.responseType;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        @Override
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public final Builder responseType(DnsResponseType responseType) {
            this.responseType(responseType == null ? null : responseType.toString());
            return this;
        }

        public DnsServiceDiscovery build() {
            return new DnsServiceDiscovery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsServiceDiscovery> {
        public Builder hostname(String var1);

        public Builder responseType(String var1);

        public Builder responseType(DnsResponseType var1);
    }
}

