/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DnsResponseType {
    LOADBALANCER("LOADBALANCER"),
    ENDPOINTS("ENDPOINTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DnsResponseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsResponseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DnsResponseType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsResponseType> knownValues() {
        return Stream.of(DnsResponseType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

