/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.ClientTlsCertificate;
import software.amazon.awssdk.services.appmesh.model.PortSetCopier;
import software.amazon.awssdk.services.appmesh.model.TlsValidationContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientPolicyTls
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientPolicyTls> {
    private static final SdkField<ClientTlsCertificate> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificate").getter(ClientPolicyTls.getter(ClientPolicyTls::certificate)).setter(ClientPolicyTls.setter(Builder::certificate)).constructor(ClientTlsCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificate").build()}).build();
    private static final SdkField<Boolean> ENFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enforce").getter(ClientPolicyTls.getter(ClientPolicyTls::enforce)).setter(ClientPolicyTls.setter(Builder::enforce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enforce").build()}).build();
    private static final SdkField<List<Integer>> PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ports").getter(ClientPolicyTls.getter(ClientPolicyTls::ports)).setter(ClientPolicyTls.setter(Builder::ports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TlsValidationContext> VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validation").getter(ClientPolicyTls.getter(ClientPolicyTls::validation)).setter(ClientPolicyTls.setter(Builder::validation)).constructor(TlsValidationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, ENFORCE_FIELD, PORTS_FIELD, VALIDATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ClientTlsCertificate certificate;
    private final Boolean enforce;
    private final List<Integer> ports;
    private final TlsValidationContext validation;

    private ClientPolicyTls(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.enforce = builder.enforce;
        this.ports = builder.ports;
        this.validation = builder.validation;
    }

    public final ClientTlsCertificate certificate() {
        return this.certificate;
    }

    public final Boolean enforce() {
        return this.enforce;
    }

    public final boolean hasPorts() {
        return this.ports != null && !(this.ports instanceof SdkAutoConstructList);
    }

    public final List<Integer> ports() {
        return this.ports;
    }

    public final TlsValidationContext validation() {
        return this.validation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPorts() ? this.ports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientPolicyTls)) {
            return false;
        }
        ClientPolicyTls other = (ClientPolicyTls)obj;
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.enforce(), other.enforce()) && this.hasPorts() == other.hasPorts() && Objects.equals(this.ports(), other.ports()) && Objects.equals(this.validation(), other.validation());
    }

    public final String toString() {
        return ToString.builder((String)"ClientPolicyTls").add("Certificate", (Object)this.certificate()).add("Enforce", (Object)this.enforce()).add("Ports", this.hasPorts() ? this.ports() : null).add("Validation", (Object)this.validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "enforce": {
                return Optional.ofNullable(clazz.cast(this.enforce()));
            }
            case "ports": {
                return Optional.ofNullable(clazz.cast(this.ports()));
            }
            case "validation": {
                return Optional.ofNullable(clazz.cast(this.validation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientPolicyTls, T> g) {
        return obj -> g.apply((ClientPolicyTls)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ClientTlsCertificate certificate;
        private Boolean enforce;
        private List<Integer> ports = DefaultSdkAutoConstructList.getInstance();
        private TlsValidationContext validation;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientPolicyTls model) {
            this.certificate(model.certificate);
            this.enforce(model.enforce);
            this.ports(model.ports);
            this.validation(model.validation);
        }

        public final ClientTlsCertificate.Builder getCertificate() {
            return this.certificate != null ? this.certificate.toBuilder() : null;
        }

        @Override
        public final Builder certificate(ClientTlsCertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(ClientTlsCertificate.BuilderImpl certificate) {
            this.certificate = certificate != null ? certificate.build() : null;
        }

        public final Boolean getEnforce() {
            return this.enforce;
        }

        @Override
        public final Builder enforce(Boolean enforce) {
            this.enforce = enforce;
            return this;
        }

        public final void setEnforce(Boolean enforce) {
            this.enforce = enforce;
        }

        public final Collection<Integer> getPorts() {
            if (this.ports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ports;
        }

        @Override
        public final Builder ports(Collection<Integer> ports) {
            this.ports = PortSetCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(Integer ... ports) {
            this.ports(Arrays.asList(ports));
            return this;
        }

        public final void setPorts(Collection<Integer> ports) {
            this.ports = PortSetCopier.copy(ports);
        }

        public final TlsValidationContext.Builder getValidation() {
            return this.validation != null ? this.validation.toBuilder() : null;
        }

        @Override
        public final Builder validation(TlsValidationContext validation) {
            this.validation = validation;
            return this;
        }

        public final void setValidation(TlsValidationContext.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        public ClientPolicyTls build() {
            return new ClientPolicyTls(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientPolicyTls> {
        public Builder certificate(ClientTlsCertificate var1);

        default public Builder certificate(Consumer<ClientTlsCertificate.Builder> certificate) {
            return this.certificate((ClientTlsCertificate)((ClientTlsCertificate.Builder)ClientTlsCertificate.builder().applyMutation(certificate)).build());
        }

        public Builder enforce(Boolean var1);

        public Builder ports(Collection<Integer> var1);

        public Builder ports(Integer ... var1);

        public Builder validation(TlsValidationContext var1);

        default public Builder validation(Consumer<TlsValidationContext.Builder> validation) {
            return this.validation((TlsValidationContext)((TlsValidationContext.Builder)TlsValidationContext.builder().applyMutation(validation)).build());
        }
    }
}

